/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Hashtable;

public class ELF {
    Object stdout;
    OpenTTY midlet;
    Hashtable scope;
    static final int EI_NIDENT = 16;
    static final int ELFCLASS32 = 1;
    static final int ELFDATA2LSB = 1;
    static final int EM_ARM = 40;
    static final int ET_EXEC = 2;
    static final int PT_LOAD = 1;
    static final int PT_DYNAMIC = 2;
    static final int PT_INTERP = 3;
    static final int PT_NOTE = 4;

    public String getPid() throws  {
        return "";
    }

    public void kill() throws  {
    }

    public boolean load(InputStream inputStream) throws Exception {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        return this.load(byteArrayOutputStream.toByteArray());
    }

    public boolean load(byte[] byArray) throws Exception {
        if (byArray.length < 4 || byArray[0] != 127 || byArray[1] != 69 || byArray[2] != 76 || byArray[3] != 70) {
            this.midlet.print("Not a valid ELF file", this.stdout, 0, this.scope);
            return false;
        }
        if (byArray[4] != 1) {
            this.midlet.print("Only 32-bit ELF supported", this.stdout, 0, this.scope);
            return false;
        }
        if (byArray[5] != 1) {
            this.midlet.print("Only little-endian ELF supported", this.stdout, 0, this.scope);
            return false;
        }
        short s = ELF.readShortLE$(this, byArray, 16);
        short s2 = ELF.readShortLE$(this, byArray, 18);
        int n = ELF.readIntLE$(this, byArray, 24);
        int n2 = ELF.readIntLE$(this, byArray, 28);
        int n3 = ELF.readIntLE$(this, byArray, 32);
        short s3 = ELF.readShortLE$(this, byArray, 44);
        short s4 = ELF.readShortLE$(this, byArray, 48);
        short s5 = ELF.readShortLE$(this, byArray, 42);
        short s6 = ELF.readShortLE$(this, byArray, 46);
        if (s != 2) {
            this.midlet.print("Not an executable ELF", this.stdout, 0, this.scope);
            return false;
        }
        if (s2 != 40) {
            this.midlet.print("Not an ARM executable", this.stdout, 0, this.scope);
            return false;
        }
        return true;
    }

    public Hashtable run() throws  {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        this.midlet.print("ELF not supported!", this.stdout, 0, this.scope);
        hashtable.put("status", new Double(69));
        return hashtable;
    }

    static int readIntLE$(ELF eLF, byte[] byArray, int n) throws  {
        if (n + 3 >= byArray.length || n < 0) {
            return 0;
        }
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    static short readShortLE$(ELF eLF, byte[] byArray, int n) throws  {
        if (n + 1 >= byArray.length || n < 0) {
            return 0;
        }
        return (short)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8);
    }

    public ELF(OpenTTY openTTY, Hashtable hashtable, Object object, Hashtable hashtable2, int n, String string, Process process) throws  {
        this.midlet = openTTY;
        this.stdout = object;
        this.scope = hashtable2;
    }
}

