/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.rms.RecordStore;

public class ELF {
    OpenTTY midlet;
    Object stdout;
    Process proc;
    Hashtable scope;
    String pid;
    int id = 1000;
    byte[] memory;
    int[] registers;
    int[] signalHandlers;
    int pc;
    int cpsr;
    boolean running;
    int stackPointer;
    Hashtable fileDescriptors;
    Hashtable socketDescriptors;
    int nextFd;
    Hashtable jmpBufs;
    int nextJmpBufId;
    Hashtable allocatedBlocks;
    int heapStart;
    int heapEnd;
    Hashtable dynamicSymbols;
    Hashtable neededLibraries;
    Hashtable globalSymbols;
    Hashtable pltEntries;
    Vector loadedLibraries;
    Vector memoryMappings;
    int pltGotAddr;
    int dynamicSectionAddr;
    int gotBase;
    int pltBase;
    int resolverCodeAddr;
    int resolveFuncAddr;
    static final int EI_NIDENT = 16;
    static final int ELFCLASS32 = 1;
    static final int ELFDATA2LSB = 1;
    static final int EM_ARM = 40;
    static final int ET_EXEC = 2;
    static final int PT_LOAD = 1;
    static final int PT_DYNAMIC = 2;
    static final int PT_INTERP = 3;
    static final int PT_NOTE = 4;
    static final int REG_R0 = 0;
    static final int REG_R1 = 1;
    static final int REG_R2 = 2;
    static final int REG_R3 = 3;
    static final int REG_R7 = 7;
    static final int REG_SP = 13;
    static final int REG_LR = 14;
    static final int REG_PC = 15;
    static final int CPSR_V = 28;
    static final int CPSR_C = 29;
    static final int CPSR_Z = 30;
    static final int CPSR_N = 31;
    static final int N_MASK = 1 << 31;
    static final int Z_MASK = 1 << 30;
    static final int C_MASK = 1 << 29;
    static final int V_MASK = 1 << 28;
    static final int COND_EQ = 0;
    static final int COND_NE = 1;
    static final int COND_CS = 2;
    static final int COND_CC = 3;
    static final int COND_MI = 4;
    static final int COND_PL = 5;
    static final int COND_VS = 6;
    static final int COND_VC = 7;
    static final int COND_HI = 8;
    static final int COND_LS = 9;
    static final int COND_GE = 10;
    static final int COND_LT = 11;
    static final int COND_GT = 12;
    static final int COND_LE = 13;
    static final int COND_AL = 14;
    static final int COND_NV = 15;
    static final int SYS_EXIT = 1;
    static final int SYS_FORK = 2;
    static final int SYS_READ = 3;
    static final int SYS_WRITE = 4;
    static final int SYS_OPEN = 5;
    static final int SYS_CLOSE = 6;
    static final int SYS_CREAT = 8;
    static final int SYS_UNLINK = 10;
    static final int SYS_EXECVE = 11;
    static final int SYS_CHDIR = 12;
    static final int SYS_TIME = 13;
    static final int SYS_LSEEK = 19;
    static final int SYS_GETPID = 20;
    static final int SYS_KILL = 37;
    static final int SYS_MKDIR = 39;
    static final int SYS_RMDIR = 40;
    static final int SYS_DUP = 41;
    static final int SYS_PIPE = 42;
    static final int SYS_IOCTL = 54;
    static final int SYS_FCNTL = 55;
    static final int SYS_SIGNAL = 48;
    static final int SYS_DUP2 = 63;
    static final int SYS_GETPPID = 64;
    static final int SYS_SIGACTION = 67;
    static final int SYS_BRK = 45;
    static final int SYS_TRUNCATE = 92;
    static final int SYS_FTRUNCATE = 93;
    static final int SYS_SETJMP = 96;
    static final int SYS_LONGJMP = 97;
    static final int SYS_FSYNC = 118;
    static final int SYS_SIGRETURN = 119;
    static final int SYS_UNAME = 122;
    static final int SYS_MPROTECT = 125;
    static final int SYS_SIGPROCMASK = 126;
    static final int SYS_STAT = 106;
    static final int SYS_FSTAT = 108;
    static final int SYS_GETTIMEOFDAY = 78;
    static final int SYS_GETPRIORITY = 140;
    static final int SYS_SETPRIORITY = 141;
    static final int SYS_SELECT = 142;
    static final int SYS_SCHED_YIELD = 158;
    static final int SYS_NANOSLEEP = 162;
    static final int SYS_MREMAP = 163;
    static final int SYS_POLL = 168;
    static final int SYS_MUNMAP = 91;
    static final int SYS_GETRLIMIT = 191;
    static final int SYS_MMAP = 192;
    static final int SYS_GETCWD = 183;
    static final int SYS_GETUID32 = 199;
    static final int SYS_GETEUID32 = 201;
    static final int SYS_GETDENTS = 217;
    static final int SYS_GETTID = 224;
    static final int SYS_FUTEX = 240;
    static final int SYS_SOCKET = 281;
    static final int SYS_BIND = 282;
    static final int SYS_CONNECT = 283;
    static final int SYS_LISTEN = 284;
    static final int SYS_ACCEPT = 285;
    static final int SYS_GETSOCKNAME = 286;
    static final int SYS_GETPEERNAME = 287;
    static final int SYS_SEND = 289;
    static final int SYS_SENDTO = 290;
    static final int SYS_RECV = 291;
    static final int SYS_RECVFROM = 292;
    static final int SYS_SHUTDOWN = 293;
    static final int SYS_SETSOCKOPT = 294;
    static final int SYS_GETSOCKOPT = 295;
    static final int SYS_SYSCALL = 0;
    static final int SOCK_STREAM = 1;
    static final int SOCK_DGRAM = 2;
    static final int AF_INET = 2;
    static final int IPPROTO_TCP = 6;
    static final int IPPROTO_UDP = 17;
    static final int SIG_ERR = -1;
    static final int SIG_DFL = 0;
    static final int SIG_IGN = 1;
    static final int SIGINT = 2;
    static final int SIGKILL = 9;
    static final int SIGSEGV = 11;
    static final int SIGPIPE = 13;
    static final int SIGTERM = 15;
    static final int SIGCHLD = 17;
    static final int SIGCONT = 18;
    static final int SIGSTOP = 19;
    static final int NSIG = 32;
    static final int TCGETS = 21505;
    static final int TCSETS = 21506;
    static final int TIOCGWINSZ = 21523;
    static final int TIOCSWINSZ = 21524;
    static final int FIONREAD = 21531;
    static final int S_IRWXU = 448;
    static final int S_IRUSR = 256;
    static final int S_IWUSR = 128;
    static final int S_IXUSR = 64;
    static final int S_IRWXG = 56;
    static final int S_IRGRP = 32;
    static final int S_IWGRP = 16;
    static final int S_IXGRP = 8;
    static final int S_IRWXO = 7;
    static final int S_IROTH = 4;
    static final int S_IWOTH = 2;
    static final int S_IXOTH = 1;
    static final int S_IFDIR = 16384;
    static final int SEEK_SET = 0;
    static final int SEEK_CUR = 1;
    static final int SEEK_END = 2;
    static final int O_RDONLY = 0;
    static final int O_WRONLY = 1;
    static final int O_RDWR = 2;
    static final int O_CREAT = 64;
    static final int O_TRUNC = 512;
    static final int O_APPEND = 1024;
    static final int O_DIRECTORY = 65536;
    static final int PROT_NONE = 0;
    static final int PROT_READ = 1;
    static final int PROT_WRITE = 2;
    static final int PROT_EXEC = 4;
    static final int MAP_SHARED = 1;
    static final int MAP_PRIVATE = 2;
    static final int MAP_FIXED = 16;
    static final int MAP_ANONYMOUS = 32;
    static final int DT_NULL = 0;
    static final int DT_NEEDED = 1;
    static final int DT_PLTRELSZ = 2;
    static final int DT_PLTGOT = 3;
    static final int DT_HASH = 4;
    static final int DT_STRTAB = 5;
    static final int DT_SYMTAB = 6;
    static final int DT_RELA = 7;
    static final int DT_RELASZ = 8;
    static final int DT_RELAENT = 9;
    static final int DT_STRSZ = 10;
    static final int DT_SYMENT = 11;
    static final int DT_INIT = 12;
    static final int DT_FINI = 13;
    static final int DT_SONAME = 14;
    static final int DT_RPATH = 15;
    static final int DT_SYMBOLIC = 16;
    static final int DT_REL = 17;
    static final int DT_RELSZ = 18;
    static final int DT_RELENT = 19;
    static final int DT_PLTREL = 20;
    static final int DT_DEBUG = 21;
    static final int DT_TEXTREL = 22;
    static final int DT_JMPREL = 23;
    static final int DT_BIND_NOW = 24;
    static final int DT_INIT_ARRAY = 25;
    static final int DT_FINI_ARRAY = 26;
    static final int DT_INIT_ARRAYSZ = 27;
    static final int DT_FINI_ARRAYSZ = 28;
    static final int R_ARM_ABS32 = 2;
    static final int R_ARM_REL32 = 3;
    static final int R_ARM_GLOB_DAT = 21;
    static final int R_ARM_JUMP_SLOT = 22;
    static final int R_ARM_RELATIVE = 23;
    static final int F_GETFL = 3;
    static final int F_SETFL = 4;
    static final int O_NONBLOCK = 2048;
    Hashtable instructionCache;
    int cacheHits;
    int cacheMisses;
    Hashtable elfInfo;
    float[] fpuRegisters;
    int fpscr;
    Vector signalStack;
    Hashtable futexWaiters;
    Hashtable args;

    public String getPid() throws  {
        return this.pid;
    }

    public void kill() throws  {
        this.running = false;
        ELF.handleExit$(this);
    }

    static String toHex$(ELF eLF, int n) throws  {
        String string = Integer.toHexString(n);
        while (string.length() < 8) {
            string = "0".concat(String.valueOf(string));
        }
        return "0x".concat(String.valueOf(string));
    }

    public boolean load(InputStream inputStream) throws Exception {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        return this.load(byteArrayOutputStream.toByteArray());
    }

    public boolean load(byte[] byArray) throws Exception {
        if (byArray.length < 4 || byArray[0] != 127 || byArray[1] != 69 || byArray[2] != 76 || byArray[3] != 70) {
            this.midlet.print("Not a valid ELF file", this.stdout, this.id, this.scope);
            return false;
        }
        if (byArray[4] != 1) {
            this.midlet.print("Only 32-bit ELF supported", this.stdout, this.id, this.scope);
            return false;
        }
        if (byArray[5] != 1) {
            this.midlet.print("Only little-endian ELF supported", this.stdout, this.id, this.scope);
            return false;
        }
        short s = ELF.readShortLE$(this, byArray, 16);
        short s2 = ELF.readShortLE$(this, byArray, 18);
        int n = ELF.readIntLE$(this, byArray, 24);
        int n2 = ELF.readIntLE$(this, byArray, 28);
        int n3 = ELF.readIntLE$(this, byArray, 32);
        int n4 = ELF.readShortLE$(this, byArray, 44);
        short s3 = ELF.readShortLE$(this, byArray, 48);
        short s4 = ELF.readShortLE$(this, byArray, 42);
        short s5 = ELF.readShortLE$(this, byArray, 46);
        if (s != 2) {
            this.midlet.print("Not an executable ELF", this.stdout, this.id, this.scope);
            return false;
        }
        if (s2 != 40) {
            this.midlet.print("Not an ARM executable", this.stdout, this.id, this.scope);
            return false;
        }
        this.elfInfo.put("entry", new Integer(n));
        this.elfInfo.put("phoff", new Integer(n2));
        this.elfInfo.put("phnum", new Integer(n4));
        this.elfInfo.put("shoff", new Integer(n3));
        this.elfInfo.put("shnum", new Integer(s3));
        Hashtable hashtable = ELF.loadSections$(this, byArray, n3, s3, s5);
        this.pc = n;
        this.registers[13] = this.stackPointer;
        this.registers[14] = -1;
        ELF.initializeBSS$(this, hashtable);
        int n5 = 0;
        while (n5 < n4) {
            int n6;
            int n7 = n2 + n5 * s4;
            int n8 = ELF.readIntLE$(this, byArray, n7);
            if (n8 == 1) {
                n6 = ELF.readIntLE$(this, byArray, n7 + 4);
                int n9 = ELF.readIntLE$(this, byArray, n7 + 8);
                int n10 = ELF.readIntLE$(this, byArray, n7 + 16);
                int n11 = ELF.readIntLE$(this, byArray, n7 + 20);
                int n12 = 0;
                while (n12 < n10 && n12 < this.memory.length) {
                    if (n9 + n12 < this.memory.length) {
                        this.memory[n9 + n12] = byArray[n6 + n12];
                    }
                    ++n12;
                }
                n12 = n10;
                while (n12 < n11) {
                    if (n9 + n12 < this.memory.length) {
                        this.memory[n9 + n12] = 0;
                    }
                    ++n12;
                }
            } else if (n8 == 2) {
                ELF.processDynamicSegment$(this, byArray, n7);
            } else if (n8 == 3) {
                n6 = ELF.readIntLE$(this, byArray, n7 + 4);
                String string = ELF.readString$(this, byArray, n6, 256);
                if (this.midlet.debug) {
                    this.midlet.print("Interpreter: ".concat(String.valueOf(string)), this.stdout, this.id, this.scope);
                }
            }
            ++n5;
        }
        ELF.processSymbolsAndRelocations$(this, byArray, hashtable);
        ELF.setupCRTStack$(this);
        ELF.processDynamicSection$(this, byArray);
        ELF.loadNeededLibraries$(this);
        ELF.processSymbolsAndRelocations$(this, byArray, hashtable);
        ELF.setupPLTGOT$(this);
        ELF.executeInitFunctions$(this);
        return true;
    }

    static void processDynamicSection$(ELF eLF, byte[] byArray) throws  {
        int n = (Integer)eLF.elfInfo.get("phoff");
        int n2 = (Integer)eLF.elfInfo.get("phnum");
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n + n3 * 32;
            int n5 = ELF.readIntLE$(eLF, byArray, n4);
            if (n5 == 2) {
                eLF.dynamicSectionAddr = ELF.readIntLE$(eLF, byArray, n4 + 8);
                int n6 = ELF.readIntLE$(eLF, byArray, n4 + 16);
                ELF.processDynamicEntries$(eLF, byArray, eLF.dynamicSectionAddr, n6);
                break;
            }
            ++n3;
        }
    }

    static void processDynamicEntries$(ELF eLF, byte[] byArray, int n, int n2) throws  {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = ELF.readIntLE$(eLF, byArray, n + n3);
            int n5 = ELF.readIntLE$(eLF, byArray, n + n3 + 4);
            if (n4 == 0) break;
            switch (n4) {
                case 1: {
                    String string = ELF.readString$(eLF, byArray, n5, 256);
                    eLF.neededLibraries.put(string, new Integer(n5));
                    if (!eLF.midlet.debug) break;
                    eLF.midlet.print("Needed library: ".concat(String.valueOf(string)), eLF.stdout, eLF.id, eLF.scope);
                    break;
                }
                case 3: {
                    eLF.pltGotAddr = n5;
                    if (!eLF.midlet.debug) break;
                    eLF.midlet.print("PLT/GOT at: ".concat(String.valueOf(ELF.toHex$(eLF, n5))), eLF.stdout, eLF.id, eLF.scope);
                    break;
                }
                case 5: {
                    eLF.elfInfo.put("dynstr", new Integer(n5));
                    break;
                }
                case 6: {
                    eLF.elfInfo.put("dynsym", new Integer(n5));
                    break;
                }
                case 11: {
                    eLF.elfInfo.put("syment", new Integer(n5));
                    break;
                }
                case 23: {
                    eLF.elfInfo.put("jmprel", new Integer(n5));
                    break;
                }
                case 2: {
                    eLF.elfInfo.put("pltrelsz", new Integer(n5));
                    break;
                }
                case 20: {
                    eLF.elfInfo.put("pltrel", new Integer(n5));
                    break;
                }
                case 17: {
                    eLF.elfInfo.put("rel", new Integer(n5));
                    break;
                }
                case 18: {
                    eLF.elfInfo.put("relsz", new Integer(n5));
                    break;
                }
                case 12: {
                    eLF.elfInfo.put("init", new Integer(n5));
                    break;
                }
                case 13: {
                    eLF.elfInfo.put("fini", new Integer(n5));
                    break;
                }
                case 4: {
                    ELF.processHashTable$(eLF, byArray, n5);
                    break;
                }
            }
            n3 += 8;
        }
    }

    static void processHashTable$(ELF eLF, byte[] byArray, int n) throws  {
        int n2 = ELF.readIntLE$(eLF, byArray, n);
        int n3 = ELF.readIntLE$(eLF, byArray, n + 4);
        eLF.elfInfo.put("nbucket", new Integer(n2));
        eLF.elfInfo.put("nchain", new Integer(n3));
        eLF.elfInfo.put("buckets", new Integer(n + 8));
        eLF.elfInfo.put("chains", new Integer(n + 8 + n2 * 4));
    }

    static void loadNeededLibraries$(ELF eLF) throws  {
        Enumeration enumeration = eLF.neededLibraries.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (eLF.loadedLibraries.contains(string)) continue;
            if (ELF.loadLibrary$(eLF, string)) {
                eLF.loadedLibraries.addElement(string);
                if (!eLF.midlet.debug) continue;
                eLF.midlet.print("Loaded library: ".concat(String.valueOf(string)), eLF.stdout, eLF.id, eLF.scope);
                continue;
            }
            if (!eLF.midlet.debug) continue;
            eLF.midlet.print("Failed to load: ".concat(String.valueOf(string)), eLF.stdout, eLF.id, eLF.scope);
        }
    }

    static boolean loadLibrary$(ELF eLF, String string) throws  {
        String[] stringArray = new String[]{"/lib/".concat(String.valueOf(string)), "/usr/lib/".concat(String.valueOf(string))};
        int n = 0;
        while (n < stringArray.length) {
            try {
                InputStream inputStream = eLF.midlet.getInputStream(stringArray[n], eLF.scope);
                if (inputStream != null) {
                    Hashtable hashtable = new Hashtable();
                    if (string.indexOf("c") != -1) {
                        hashtable.put("printf", eLF.globalSymbols.get("libc.so.6"));
                    }
                    if (string.indexOf("m") != -1) {
                        hashtable.put("sin", new Integer(ELF.createSimpleStub$(eLF, 32)));
                        hashtable.put("cos", new Integer(ELF.createSimpleStub$(eLF, 32)));
                    }
                    eLF.globalSymbols.put(string, hashtable);
                    inputStream.close();
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        return false;
    }

    static void loadDefaultLibraries$(ELF eLF) throws  {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("printf", new Integer(ELF.createSyscallStub$(eLF, "write")));
        hashtable.put("puts", new Integer(ELF.createSyscallStub$(eLF, "write")));
        hashtable.put("malloc", new Integer(ELF.createSyscallStub$(eLF, "brk")));
        hashtable.put("free", new Integer(ELF.createSyscallStub$(eLF, "brk")));
        hashtable.put("strlen", new Integer(ELF.createSimpleStub$(eLF, 16)));
        hashtable.put("strcpy", new Integer(ELF.createSimpleStub$(eLF, 32)));
        hashtable.put("strcmp", new Integer(ELF.createSimpleStub$(eLF, 32)));
        hashtable.put("memcpy", new Integer(ELF.createSimpleStub$(eLF, 48)));
        hashtable.put("memset", new Integer(ELF.createSimpleStub$(eLF, 32)));
        hashtable.put("exit", new Integer(ELF.createSyscallStub$(eLF, "exit")));
        hashtable.put("open", new Integer(ELF.createSyscallStub$(eLF, "open")));
        hashtable.put("read", new Integer(ELF.createSyscallStub$(eLF, "read")));
        hashtable.put("write", new Integer(ELF.createSyscallStub$(eLF, "write")));
        hashtable.put("close", new Integer(ELF.createSyscallStub$(eLF, "close")));
        eLF.globalSymbols.put("libc.so.6", hashtable);
        eLF.loadedLibraries.addElement("libc.so.6");
        if (eLF.midlet.debug) {
            eLF.midlet.print("Loaded default libraries", eLF.stdout, eLF.id, eLF.scope);
        }
    }

    public Hashtable run() throws  {
        this.running = true;
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        try {
            try {
                if (this.midlet.debug) {
                    this.midlet.print("=== ELF START DEBUG ===", this.stdout, this.id, this.scope);
                    this.midlet.print("PC start: ".concat(String.valueOf(ELF.toHex$(this, this.pc))), this.stdout, this.id, this.scope);
                    this.midlet.print("SP: ".concat(String.valueOf(ELF.toHex$(this, this.registers[13]))), this.stdout, this.id, this.scope);
                    this.midlet.print("Memory: ".concat(String.valueOf(this.memory.length)).concat(" bytes"), this.stdout, this.id, this.scope);
                }
                int n = 0;
                while (this.running && this.pc < this.memory.length - 3 && this.midlet.sys.containsKey(this.pid)) {
                    if (n++ > 100000) {
                        if (!this.midlet.debug) break;
                        this.midlet.print("DEBUG: Stopping after 100000 instructions", this.stdout, this.id, this.scope);
                        break;
                    }
                    ELF.checkPendingSignals$(this);
                    if (this.midlet.debug && n % 10000 == 0) {
                        this.midlet.print("DEBUG: PC=" + String.valueOf(ELF.toHex$(this, this.pc)) + ", R7=" + String.valueOf(this.registers[7]), this.stdout, this.id, this.scope);
                    }
                    int n2 = ELF.fetchInstruction$(this, this.pc);
                    if (this.midlet.debug && n < 10) {
                        this.midlet.print("DEBUG: Instr at PC " + String.valueOf(ELF.toHex$(this, this.pc)) + ": " + String.valueOf(ELF.toHex$(this, n2)), this.stdout, this.id, this.scope);
                    }
                    this.pc += 4;
                    try {
                        ELF.executeInstruction$(this, n2);
                    }
                    catch (Exception exception) {
                        if (this.midlet.debug) {
                            this.midlet.print("DEBUG: Exception in executeInstruction: ".concat(String.valueOf(exception)), this.stdout, this.id, this.scope);
                        }
                        exception.printStackTrace();
                        ELF.handleSignal$(this, 11);
                        this.running = false;
                        break;
                    }
                }
                if (this.midlet.debug) {
                    this.midlet.print("=== ELF END DEBUG ===\nInstructions executed: ".concat(String.valueOf(n)), this.stdout, this.id, this.scope);
                }
            }
            catch (Throwable throwable) {
                if (this.midlet.debug) {
                    this.midlet.print("=== ELF CRASH DEBUG ===\nCRASH: " + String.valueOf(throwable.getClass().getName()) + ": " + String.valueOf(throwable.getMessage()), this.stdout, this.id, this.scope);
                }
                throwable.printStackTrace();
                this.running = false;
            }
        }
        finally {
            if (this.midlet.debug) {
                this.midlet.print("=== ELF FINALLY DEBUG ===", this.stdout, this.id, this.scope);
            }
            if (this.midlet.sys.containsKey(this.pid)) {
                this.midlet.sys.remove(this.pid);
            }
        }
        hashtable.put("status", new Double(0.0));
        return hashtable;
    }

    static int fetchInstruction$(ELF eLF, int n) throws  {
        Integer n2 = new Integer(n);
        if (eLF.instructionCache.containsKey(n2)) {
            ++eLF.cacheHits;
            return (Integer)eLF.instructionCache.get(n2);
        }
        ++eLF.cacheMisses;
        int n3 = ELF.readIntLE$(eLF, eLF.memory, n);
        if ((n3 & 0xE000000) != 0xA000000) {
            eLF.instructionCache.put(n2, new Integer(n3));
        }
        return n3;
    }

    static void executeInstruction$(ELF eLF, int n) throws  {
        int n2;
        int n3 = n >> 28 & 0xF;
        if (!ELF.checkCondition$(eLF, n3)) {
            return;
        }
        if ((n & 0xFF000000) == -352321536) {
            n2 = n & 0xFFFFFF;
            if ((n2 & 0x800000) != 0) {
                n2 |= 0xFF000000;
            }
            int n4 = eLF.pc + (n2 <<= 2) - 4;
            if (eLF.pltBase != 0 && n4 >= eLF.pltBase && n4 < eLF.pltBase + 4096) {
                ELF.handlePLTCall$(eLF, n4);
                return;
            }
        }
        if ((n & 0xF000000) == 0xF000000) {
            n2 = n & 0xFFFFFF;
            if (n2 == 0) {
                ELF.handleSyscall$(eLF, eLF.registers[7]);
            } else {
                ELF.handleSyscall$(eLF, n2);
            }
            return;
        }
        if ((n & 0xFC000F0) == 144) {
            ELF.handleMultiply$(eLF, n);
            return;
        }
        if ((n & 0xF8000F0) == 0x800090) {
            ELF.handleLongMultiply$(eLF, n);
            return;
        }
        if ((n & 0xE000000) == 0x8000000) {
            ELF.handleLoadStoreMultiple$(eLF, n);
            return;
        }
        if ((n & 0xE000000) == 0xC000000) {
            ELF.handleCoprocessor$(eLF, n);
            return;
        }
        if ((n & 0xC000000) == 0) {
            ELF.handleDataProcessing$(eLF, n);
            return;
        }
        if ((n & 0xC000000) == 0x4000000) {
            ELF.handleLoadStore$(eLF, n);
            return;
        }
        if ((n & 0xE000000) == 0xA000000) {
            ELF.handleBranch$(eLF, n);
            return;
        }
        if ((n & 0xF000000) == 0x2800000 || (n & 0xF000000) == 0x2400000) {
            ELF.handleAdrSub$(eLF, n);
            return;
        }
        if (n == -509607936) {
            return;
        }
        if (eLF.midlet.debug) {
            eLF.midlet.print("[WARN] Unrecognized instruction: " + String.valueOf(ELF.toHex$(eLF, n)) + " at PC: " + String.valueOf(ELF.toHex$(eLF, eLF.pc - 4)), eLF.stdout, eLF.id, eLF.scope);
        }
    }

    static void executeInitFunctions$(ELF eLF) throws  {
        int n;
        if (eLF.elfInfo.containsKey("init") && (n = ((Integer)eLF.elfInfo.get("init")).intValue()) != 0) {
            int n2 = eLF.pc;
            int n3 = eLF.registers[13];
            eLF.registers[14] = n2;
            eLF.pc = n;
            if (eLF.midlet.debug) {
                eLF.midlet.print("Calling .init at ".concat(String.valueOf(ELF.toHex$(eLF, n))), eLF.stdout, eLF.id, eLF.scope);
            }
            int n4 = 0;
            while (n4 < 100 && eLF.running) {
                int n5 = ELF.fetchInstruction$(eLF, eLF.pc);
                eLF.pc += 4;
                ELF.executeInstruction$(eLF, n5);
                ++n4;
            }
            eLF.pc = n2;
            eLF.registers[13] = n3;
        }
    }

    static boolean checkCondition$(ELF eLF, int n) throws  {
        switch (n) {
            case 0: {
                return (eLF.cpsr & Z_MASK) != 0;
            }
            case 1: {
                return (eLF.cpsr & Z_MASK) == 0;
            }
            case 2: {
                return (eLF.cpsr & C_MASK) != 0;
            }
            case 3: {
                return (eLF.cpsr & C_MASK) == 0;
            }
            case 4: {
                return (eLF.cpsr & N_MASK) != 0;
            }
            case 5: {
                return (eLF.cpsr & N_MASK) == 0;
            }
            case 6: {
                return (eLF.cpsr & V_MASK) != 0;
            }
            case 7: {
                return (eLF.cpsr & V_MASK) == 0;
            }
            case 8: {
                return (eLF.cpsr & C_MASK) != 0 && (eLF.cpsr & Z_MASK) == 0;
            }
            case 9: {
                return (eLF.cpsr & C_MASK) == 0 || (eLF.cpsr & Z_MASK) != 0;
            }
            case 10: {
                return (eLF.cpsr & N_MASK) != 0 == ((eLF.cpsr & V_MASK) != 0);
            }
            case 11: {
                return (eLF.cpsr & N_MASK) != 0 != ((eLF.cpsr & V_MASK) != 0);
            }
            case 12: {
                return (eLF.cpsr & Z_MASK) == 0 && (eLF.cpsr & N_MASK) != 0 == ((eLF.cpsr & V_MASK) != 0);
            }
            case 13: {
                return (eLF.cpsr & Z_MASK) != 0 || (eLF.cpsr & N_MASK) != 0 != ((eLF.cpsr & V_MASK) != 0);
            }
            case 14: {
                return true;
            }
            case 15: {
                return false;
            }
        }
        return true;
    }

    static void handleMultiply$(ELF eLF, int n) throws  {
        boolean bl = (n & 1 << 21) != 0;
        boolean bl2 = (n & 1 << 20) != 0;
        int n2 = n >> 16 & 0xF;
        int n3 = n >> 12 & 0xF;
        int n4 = n >> 8 & 0xF;
        int n5 = n & 0xF;
        long l = (long)eLF.registers[n5] * (long)eLF.registers[n4];
        if (bl) {
            l += (long)eLF.registers[n3];
        }
        eLF.registers[n2] = (int)l;
        if (bl2) {
            ELF.updateFlags$(eLF, eLF.registers[n2], -1);
        }
    }

    static void handleLongMultiply$(ELF eLF, int n) throws  {
        boolean bl = (n & 1 << 22) != 0;
        boolean bl2 = (n & 1 << 21) != 0;
        boolean bl3 = (n & 1 << 20) != 0;
        int n2 = n >> 16 & 0xF;
        int n3 = n >> 12 & 0xF;
        int n4 = n >> 8 & 0xF;
        int n5 = n & 0xF;
        long l = eLF.registers[n5];
        long l2 = eLF.registers[n4];
        if (bl) {
            l = (int)l;
            l2 = (int)l2;
        } else {
            l &= 0xFFFFFFFFL;
            l2 &= 0xFFFFFFFFL;
        }
        long l3 = l * l2;
        if (bl2) {
            long l4 = (long)eLF.registers[n2] << 32 | (long)eLF.registers[n3] & 0xFFFFFFFFL;
            l3 += l4;
        }
        eLF.registers[n2] = (int)(l3 >> 32);
        eLF.registers[n3] = (int)l3;
        if (bl3) {
            boolean bl4;
            boolean bl5 = l3 >> 63 != (long)0;
            boolean bl6 = bl4 = l3 == (long)0;
            eLF.cpsr = bl5 ? (eLF.cpsr |= N_MASK) : (eLF.cpsr &= ~N_MASK);
            eLF.cpsr = bl4 ? (eLF.cpsr |= Z_MASK) : (eLF.cpsr &= ~Z_MASK);
        }
    }

    static void handleLoadStoreMultiple$(ELF eLF, int n) throws  {
        int n2;
        boolean bl = (n & 1 << 20) != 0;
        boolean bl2 = (n & 1 << 21) != 0;
        boolean bl3 = (n & 1 << 22) != 0;
        boolean bl4 = (n & 1 << 23) != 0;
        boolean bl5 = (n & 1 << 24) != 0;
        int n3 = n >> 16 & 0xF;
        int n4 = n & 0xFFFF;
        int n5 = n2 = eLF.registers[n3];
        int n6 = 0;
        int n7 = 0;
        while (n7 < 16) {
            if ((n4 & 1 << n7) != 0) {
                ++n6;
            }
            ++n7;
        }
        if (bl5) {
            n2 = bl4 ? (n2 += 4) : (n2 -= 4 * n6);
        }
        n7 = 0;
        while (n7 < 16) {
            if ((n4 & 1 << n7) != 0) {
                if (bl) {
                    if (n2 >= 0 && n2 + 3 < eLF.memory.length) {
                        eLF.registers[n7] = ELF.readIntLE$(eLF, eLF.memory, n2);
                    }
                } else if (n2 >= 0 && n2 + 3 < eLF.memory.length) {
                    ELF.writeIntLE$(eLF, eLF.memory, n2, eLF.registers[n7]);
                }
                n2 = bl4 ? (n2 += 4) : (n2 -= 4);
            }
            ++n7;
        }
        if (bl2) {
            eLF.registers[n3] = bl4 ? n5 + 4 * n6 : n5 - 4 * n6;
        }
    }

    static void handleCoprocessor$(ELF eLF, int n) throws  {
        int n2 = n >> 8 & 0xF;
        if (n2 == 10 || n2 == 11) {
            ELF.handleFPU$(eLF, n);
        } else {
            eLF.midlet.print("[WARN] Coprocessor ".concat(String.valueOf(n2)).concat(" not implemented"), eLF.stdout, eLF.id, eLF.scope);
        }
    }

    static void handleFPU$(ELF eLF, int n) throws  {
        int n2 = n >> 20 & 0xF;
        int n3 = n >> 16 & 0xF;
        int n4 = n >> 12 & 0xF;
        int n5 = n >> 16 & 0xF;
        int n6 = n & 0xF;
        int n7 = n >> 8 & 0xF;
        if ((n & 0xF000000) == 0xC000000) {
            if ((n & 1 << 4) != 0) {
                ELF.handleFPURegisterTransfer$(eLF, n);
            } else {
                ELF.handleFPUDataProcessing$(eLF, n);
            }
        } else if ((n & 0xE000000) == 0xC400000) {
            ELF.handleFPULoadStore$(eLF, n);
        }
    }

    static void handleFPURegisterTransfer$(ELF eLF, int n) throws  {
        boolean bl = (n & 1 << 20) != 0;
        int n2 = n >> 12 & 0xF;
        int n3 = n >> 16 & 0xF;
        if (bl) {
            if (n3 == 1) {
                eLF.registers[n2] = eLF.fpscr;
            } else {
                int n4 = n3;
                eLF.registers[n2] = Float.floatToIntBits(eLF.fpuRegisters[n4]);
            }
        } else if (n3 == 1) {
            eLF.fpscr = eLF.registers[n2];
        } else {
            int n5 = n3;
            eLF.fpuRegisters[n5] = Float.intBitsToFloat(eLF.registers[n2]);
        }
    }

    static void handleFPUDataProcessing$(ELF eLF, int n) throws  {
        int n2 = n >> 20 & 0xFF;
        int n3 = n >> 12 & 0xF | (n & 0x10) << 1;
        int n4 = n >> 16 & 0xF | (n & 0x100000) >> 15;
        int n5 = n & 0xF;
        float f = eLF.fpuRegisters[n4];
        float f2 = eLF.fpuRegisters[n5];
        float f3 = 0.0f;
        switch (n2) {
            case 0: {
                f3 = f + f2;
                break;
            }
            case 1: {
                f3 = f - f2;
                break;
            }
            case 2: {
                f3 = f * f2;
                break;
            }
            case 3: {
                f3 = f / f2;
                break;
            }
            case 4: {
                f3 = -f;
                break;
            }
            case 5: {
                f3 = Math.abs(f);
                break;
            }
            case 6: {
                f3 = (float)Math.sqrt(f);
                break;
            }
            case 7: {
                int n6 = 0;
                n6 = Float.isNaN(f) || Float.isNaN(f2) ? (n6 |= 1) : (f == f2 ? (n6 |= 6) : (f < f2 ? (n6 |= 8) : (n6 |= 2)));
                eLF.fpscr = eLF.fpscr & ~15 | n6;
                return;
            }
            default: {
                eLF.midlet.print("[WARN] FPU opcode ".concat(String.valueOf(n2)).concat(" not implemented"), eLF.stdout, eLF.id, eLF.scope);
                return;
            }
        }
        eLF.fpuRegisters[n3] = f3;
        if (Float.isNaN(f3)) {
            eLF.fpscr |= 1;
        } else if (Float.isInfinite(f3)) {
            eLF.fpscr |= 4;
        } else if (f3 == 0.0f) {
            eLF.fpscr |= 2;
        }
    }

    static void handleFPULoadStore$(ELF eLF, int n) throws  {
        boolean bl = (n & 1 << 20) != 0;
        boolean bl2 = (n & 1 << 23) != 0;
        boolean bl3 = (n & 1 << 24) != 0;
        int n2 = n >> 16 & 0xF;
        int n3 = n >> 12 & 0xF | (n & 0x10) << 1;
        int n4 = n & 0xFF;
        int n5 = eLF.registers[n2];
        if (bl3) {
            n5 = bl2 ? (n5 += 4) : (n5 -= 4);
        }
        if (bl) {
            if (n5 >= 0 && n5 + 3 < eLF.memory.length) {
                int n6 = ELF.readIntLE$(eLF, eLF.memory, n5);
                eLF.fpuRegisters[n3] = Float.intBitsToFloat(n6);
            }
        } else if (n5 >= 0 && n5 + 3 < eLF.memory.length) {
            int n7 = Float.floatToIntBits(eLF.fpuRegisters[n3]);
            ELF.writeIntLE$(eLF, eLF.memory, n5, n7);
        }
        if ((n & 1 << 21) != 0) {
            eLF.registers[n2] = bl2 ? n5 + 4 : n5 - 4;
        }
    }

    static void handleDataProcessing$(ELF eLF, int n) throws  {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n >> 21 & 0xF;
        int n9 = (n & 1 << 20) >> 20;
        int n10 = n >> 16 & 0xF;
        int n11 = n >> 12 & 0xF;
        int n12 = n7 = (eLF.cpsr & C_MASK) != 0 ? 1 : 0;
        if ((n & 1 << 25) != 0) {
            n6 = n & 0xFF;
            n5 = (n >> 8 & 0xF) * 2;
            n4 = ELF.rotateRight$(eLF, n6, n5);
            if (n5 != 0) {
                n7 = n3 = n6 >> n5 - 1 & 1;
            }
        } else {
            n6 = n & 0xF;
            n5 = n >> 5 & 3;
            if ((n & 1 << 4) == 0) {
                n3 = n >> 7 & 0x1F;
            } else {
                n2 = n >> 8 & 0xF;
                n3 = eLF.registers[n2] & 0xFF;
            }
            n2 = eLF.registers[n6];
            n4 = ELF.applyShift$(eLF, n2, n5, n3, n7);
        }
        n6 = n10 == 15 ? eLF.pc + 4 : eLF.registers[n10];
        n5 = 0;
        n3 = 0;
        n2 = (eLF.cpsr & C_MASK) != 0 ? 1 : 0;
        switch (n8) {
            case 0: {
                n5 = n6 & n4;
                n3 = 1;
                break;
            }
            case 1: {
                n5 = n6 ^ n4;
                n3 = 1;
                break;
            }
            case 2: {
                n5 = n6 - n4;
                n3 = 1;
                n7 = n6 >= n4 ? 1 : 0;
                break;
            }
            case 3: {
                n5 = n4 - n6;
                n3 = 1;
                n7 = n4 >= n6 ? 1 : 0;
                break;
            }
            case 4: {
                int n13;
                n5 = n13 = n6 + n4;
                n3 = 1;
                boolean bl = (n6 ^ n4) >= 0 && (n6 ^ n13) < 0;
                n7 = bl ? 1 : 0;
                break;
            }
            case 5: {
                int n14;
                n5 = n14 = n6 + n4 + n2;
                n3 = 1;
                long l = (long)n6 + (long)n4 + (long)n2;
                n7 = l > 0xFFFFFFFFL ? 1 : 0;
                break;
            }
            case 6: {
                int n15;
                n5 = n15 = n6 - n4 - (1 - n2);
                n3 = 1;
                n7 = n6 >= n4 + (1 - n2) ? 1 : 0;
                break;
            }
            case 7: {
                int n16;
                n5 = n16 = n4 - n6 - (1 - n2);
                n3 = 1;
                n7 = n4 >= n6 + (1 - n2) ? 1 : 0;
                break;
            }
            case 8: {
                n5 = n6 & n4;
                n9 = 1;
                n3 = 1;
                break;
            }
            case 9: {
                n5 = n6 ^ n4;
                n9 = 1;
                n3 = 1;
                break;
            }
            case 10: {
                n5 = n6 - n4;
                n9 = 1;
                n3 = 1;
                n7 = n6 >= n4 ? 1 : 0;
                break;
            }
            case 11: {
                int n17;
                n5 = n17 = n6 + n4;
                n9 = 1;
                n3 = 1;
                long l = (long)n6 + (long)n4;
                n7 = l > 0xFFFFFFFFL ? 1 : 0;
                break;
            }
            case 12: {
                n5 = n6 | n4;
                n3 = 1;
                break;
            }
            case 13: {
                n5 = n4;
                n3 = 1;
                break;
            }
            case 14: {
                n5 = n6 & ~n4;
                n3 = 1;
                break;
            }
            case 15: {
                n5 = ~n4;
                n3 = 1;
                break;
            }
        }
        if (n8 != 8 && n8 != 9 && n8 != 10 && n8 != 11) {
            eLF.registers[n11] = n5;
        }
        if (n9 != 0) {
            ELF.updateFlags$(eLF, n5, n3 != 0 ? n7 : -1);
            if (n8 == 2 || n8 == 3 || n8 == 4 || n8 == 5 || n8 == 6 || n8 == 7 || n8 == 10 || n8 == 11) {
                ELF.updateOverflow$(eLF, n6, n4, n5, n8);
            }
        }
    }

    static void handleLoadStore$(ELF eLF, int n) throws  {
        int n2 = n >> 16 & 0xF;
        int n3 = n >> 12 & 0xF;
        int n4 = n & 0xFFF;
        boolean bl = (n & 1 << 20) != 0;
        boolean bl2 = (n & 1 << 22) != 0;
        boolean bl3 = (n & 1 << 23) != 0;
        boolean bl4 = (n & 1 << 24) != 0;
        boolean bl5 = (n & 1 << 21) != 0;
        int n5 = n2 == 15 ? eLF.pc + 4 : eLF.registers[n2];
        int n6 = n5;
        if (bl4) {
            n6 = bl3 ? (n6 += n4) : (n6 -= n4);
            if (bl5 && n2 != 15) {
                eLF.registers[n2] = n6;
            }
        }
        if (bl) {
            if (n6 >= 0 && n6 < eLF.memory.length) {
                if (bl2) {
                    eLF.registers[n3] = eLF.memory[n6] & 0xFF;
                } else {
                    int n7 = n6 & ~3;
                    if (n7 + 3 < eLF.memory.length) {
                        eLF.registers[n3] = ELF.readIntLE$(eLF, eLF.memory, n7);
                    }
                }
            }
        } else if (n6 >= 0 && n6 < eLF.memory.length) {
            if (bl2) {
                eLF.memory[n6] = (byte)(eLF.registers[n3] & 0xFF);
            } else {
                ELF.writeIntLE$(eLF, eLF.memory, n6, eLF.registers[n3]);
            }
        }
        if (!bl4) {
            if (bl3) {
                int n8 = n2;
                eLF.registers[n8] = eLF.registers[n8] + n4;
            } else {
                int n9 = n2;
                eLF.registers[n9] = eLF.registers[n9] - n4;
            }
        }
    }

    static void handleBranch$(ELF eLF, int n) throws  {
        boolean bl;
        int n2 = n & 0xFFFFFF;
        if ((n2 & 0x800000) != 0) {
            n2 |= 0xFF000000;
        }
        n2 <<= 2;
        boolean bl2 = bl = (n & 1 << 24) != 0;
        if (bl) {
            eLF.registers[14] = eLF.pc;
        }
        eLF.pc = eLF.pc + n2 - 4;
    }

    static void handleAdrSub$(ELF eLF, int n) throws  {
        boolean bl = (n & 0xF000000) == 0x2800000;
        int n2 = n >> 12 & 0xF;
        int n3 = n & 0xFF;
        int n4 = (n >> 8 & 0xF) * 2;
        int n5 = ELF.rotateRight$(eLF, n3, n4);
        int n6 = eLF.pc + 4;
        eLF.registers[n2] = bl ? n6 + n5 : n6 - n5;
    }

    static int applyShift$(ELF eLF, int n, int n2, int n3, int n4) throws  {
        if (n3 == 0) {
            return n;
        }
        switch (n2) {
            case 0: {
                if (n3 >= 32) {
                    eLF.cpsr = eLF.cpsr & ~C_MASK | n << n3 - 1 >>> 31 << 29;
                    return 0;
                }
                eLF.cpsr = eLF.cpsr & ~C_MASK | n << n3 - 1 >>> 31 << 29;
                return n << n3;
            }
            case 1: {
                if (n3 >= 32) {
                    eLF.cpsr = eLF.cpsr & ~C_MASK | (n >>> n3 - 1 & 1) << 29;
                    return 0;
                }
                eLF.cpsr = eLF.cpsr & ~C_MASK | (n >>> n3 - 1 & 1) << 29;
                return n >>> n3;
            }
            case 2: {
                if (n3 >= 32) {
                    int n5 = n >>> 31;
                    eLF.cpsr = eLF.cpsr & ~C_MASK | n5 << 29;
                    return n5 == 0 ? 0 : -1;
                }
                eLF.cpsr = eLF.cpsr & ~C_MASK | (n >>> n3 - 1 & 1) << 29;
                return n >> n3;
            }
            case 3: {
                if ((n3 &= 0x1F) == 0) {
                    int n6 = n4 << 31 | n >>> 1;
                    eLF.cpsr = eLF.cpsr & ~C_MASK | (n & 1) << 29;
                    return n6;
                }
                int n7 = ELF.rotateRight$(eLF, n, n3);
                eLF.cpsr = eLF.cpsr & ~C_MASK | (n >>> n3 - 1 & 1) << 29;
                return n7;
            }
        }
        return n;
    }

    static void updateFlags$(ELF eLF, int n, int n2) throws  {
        eLF.cpsr = (n & Integer.MIN_VALUE) != 0 ? (eLF.cpsr |= N_MASK) : (eLF.cpsr &= ~N_MASK);
        eLF.cpsr = n == 0 ? (eLF.cpsr |= Z_MASK) : (eLF.cpsr &= ~Z_MASK);
        if (n2 >= 0) {
            eLF.cpsr = n2 != 0 ? (eLF.cpsr |= C_MASK) : (eLF.cpsr &= ~C_MASK);
        }
    }

    static void updateOverflow$(ELF eLF, int n, int n2, int n3, int n4) throws  {
        boolean bl = false;
        switch (n4) {
            case 2: 
            case 10: {
                bl = ((n ^ n2) & (n ^ n3) & Integer.MIN_VALUE) != 0;
                break;
            }
            case 3: {
                bl = ((n2 ^ n) & (n2 ^ n3) & Integer.MIN_VALUE) != 0;
                break;
            }
            case 4: 
            case 11: {
                bl = (~(n ^ n2) & (n ^ n3) & Integer.MIN_VALUE) != 0;
                break;
            }
        }
        eLF.cpsr = bl ? (eLF.cpsr |= V_MASK) : (eLF.cpsr &= ~V_MASK);
    }

    static Hashtable loadSections$(ELF eLF, byte[] byArray, int n, int n2, int n3) throws  {
        Hashtable hashtable = new Hashtable();
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n + n4 * n3;
            int n6 = ELF.readIntLE$(eLF, byArray, n5);
            int n7 = ELF.readIntLE$(eLF, byArray, n5 + 4);
            int n8 = ELF.readIntLE$(eLF, byArray, n5 + 8);
            int n9 = ELF.readIntLE$(eLF, byArray, n5 + 12);
            int n10 = ELF.readIntLE$(eLF, byArray, n5 + 16);
            int n11 = ELF.readIntLE$(eLF, byArray, n5 + 20);
            int n12 = ELF.readIntLE$(eLF, byArray, n5 + 24);
            int n13 = ELF.readIntLE$(eLF, byArray, n5 + 28);
            int n14 = ELF.readIntLE$(eLF, byArray, n5 + 32);
            int n15 = ELF.readIntLE$(eLF, byArray, n5 + 36);
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            hashtable2.put("type", new Integer(n7));
            hashtable2.put("flags", new Integer(n8));
            hashtable2.put("addr", new Integer(n9));
            hashtable2.put("offset", new Integer(n10));
            hashtable2.put("size", new Integer(n11));
            hashtable2.put("link", new Integer(n12));
            hashtable2.put("info", new Integer(n13));
            hashtable2.put("addralign", new Integer(n14));
            hashtable2.put("entsize", new Integer(n15));
            if (n6 != 0 && eLF.elfInfo.containsKey(".shstrtab")) {
                int n16 = (Integer)eLF.elfInfo.get(".shstrtab");
                String string = ELF.readString$(eLF, byArray, n16 + n6, 64);
                hashtable.put(string, hashtable2);
                if (eLF.midlet.debug) {
                    eLF.midlet.print("Section: " + String.valueOf(string) + " at " + String.valueOf(ELF.toHex$(eLF, n9)), eLF.stdout, eLF.id, eLF.scope);
                }
            }
            if (n7 == 3) {
                eLF.elfInfo.put(".shstrtab", new Integer(n10));
            }
            ++n4;
        }
        return hashtable;
    }

    static void initializeBSS$(ELF eLF, Hashtable hashtable) throws  {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.equals(".bss") && !string.equals(".sbss")) continue;
            Hashtable hashtable2 = (Hashtable)hashtable.get(string);
            int n = (Integer)hashtable2.get("addr");
            int n2 = (Integer)hashtable2.get("size");
            int n3 = 0;
            while (n3 < n2 && n + n3 < eLF.memory.length) {
                eLF.memory[n + n3] = 0;
                ++n3;
            }
            if (!eLF.midlet.debug) continue;
            eLF.midlet.print("Zeroed " + String.valueOf(string) + " at " + String.valueOf(ELF.toHex$(eLF, n)) + " size " + String.valueOf(n2), eLF.stdout, eLF.id, eLF.scope);
        }
    }

    static void processDynamicSegment$(ELF eLF, byte[] byArray, int n) throws  {
        int n2 = ELF.readIntLE$(eLF, byArray, n + 4);
        int n3 = ELF.readIntLE$(eLF, byArray, n + 8);
        int n4 = ELF.readIntLE$(eLF, byArray, n + 16);
        if (eLF.midlet.debug) {
            eLF.midlet.print("Dynamic segment at ".concat(String.valueOf(ELF.toHex$(eLF, n3))), eLF.stdout, eLF.id, eLF.scope);
        }
        int n5 = 0;
        while (n5 < n4) {
            int n6 = ELF.readIntLE$(eLF, byArray, n2 + n5);
            int n7 = ELF.readIntLE$(eLF, byArray, n2 + n5 + 4);
            if (n6 == 0) break;
            switch (n6) {
                case 1: {
                    String string = ELF.readString$(eLF, byArray, n7, 64);
                    if (!eLF.midlet.debug) break;
                    eLF.midlet.print("Needs library: ".concat(String.valueOf(string)), eLF.stdout, eLF.id, eLF.scope);
                    break;
                }
                case 5: {
                    eLF.elfInfo.put("dynstr", new Integer(n7));
                    break;
                }
                case 6: {
                    eLF.elfInfo.put("dynsym", new Integer(n7));
                    break;
                }
            }
            n5 += 8;
        }
    }

    static void processSymbolsAndRelocations$(ELF eLF, byte[] byArray, Hashtable hashtable) throws  {
        if (!eLF.elfInfo.containsKey("dynsym") || !eLF.elfInfo.containsKey("dynstr")) {
            return;
        }
        int n = (Integer)eLF.elfInfo.get("dynsym");
        int n2 = (Integer)eLF.elfInfo.get("dynstr");
        int n3 = eLF.elfInfo.containsKey("syment") ? (Integer)eLF.elfInfo.get("syment") : 16;
        int n4 = n;
        while (true) {
            int n5 = ELF.readIntLE$(eLF, byArray, n4);
            int n6 = ELF.readIntLE$(eLF, byArray, n4 + 4);
            int n7 = ELF.readIntLE$(eLF, byArray, n4 + 8);
            int n8 = byArray[n4 + 12] & 0xFF;
            if (n5 == 0 && n6 == 0 && n7 == 0 && n8 == 0) break;
            String string = ELF.readString$(eLF, byArray, n2 + n5, 256);
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            hashtable2.put("value", new Integer(n6));
            hashtable2.put("size", new Integer(n7));
            hashtable2.put("info", new Integer(n8));
            hashtable2.put("binding", new Integer(n8 >> 4 & 0xF));
            hashtable2.put("type", new Integer(n8 & 0xF));
            eLF.dynamicSymbols.put(string, hashtable2);
            n4 += n3;
        }
        ELF.processRelocations$(eLF, byArray);
    }

    static void processRelocations$(ELF eLF, byte[] byArray) throws  {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (eLF.elfInfo.containsKey("rel") && eLF.elfInfo.containsKey("relsz")) {
            n9 = (Integer)eLF.elfInfo.get("rel");
            n8 = (Integer)eLF.elfInfo.get("relsz");
            n7 = 8;
            n6 = 0;
            while (n6 < n8) {
                n5 = n9 + n6;
                n4 = ELF.readIntLE$(eLF, byArray, n5);
                n3 = ELF.readIntLE$(eLF, byArray, n5 + 4);
                n2 = n3 >> 8;
                n = n3 & 0xFF;
                ELF.applyRelocation$(eLF, n4, n, n2, 0);
                n6 += n7;
            }
        }
        if (eLF.elfInfo.containsKey("jmprel") && eLF.elfInfo.containsKey("pltrelsz")) {
            n9 = (Integer)eLF.elfInfo.get("jmprel");
            n8 = (Integer)eLF.elfInfo.get("pltrelsz");
            n7 = eLF.elfInfo.containsKey("pltrel") ? (Integer)eLF.elfInfo.get("pltrel") : 17;
            n6 = n7 == 7 ? 12 : 8;
            n5 = n8 / n6;
            if (eLF.gotBase == 0 && eLF.pltGotAddr != 0) {
                eLF.gotBase = eLF.pltGotAddr + 12;
            }
            n4 = 0;
            while (n4 < n5) {
                n3 = n9 + n4 * n6;
                n2 = ELF.readIntLE$(eLF, byArray, n3);
                n = ELF.readIntLE$(eLF, byArray, n3 + 4);
                int n10 = n >> 8;
                int n11 = n & 0xFF;
                if (n11 == 22) {
                    ELF.setupLazyBinding$(eLF, n2, n10, n4);
                } else {
                    ELF.applyRelocation$(eLF, n2, n11, n10, 0);
                }
                ++n4;
            }
        }
    }

    static void applyRelocation$(ELF eLF, int n, int n2, int n3, int n4) throws  {
        switch (n2) {
            case 2: 
            case 21: {
                String string = ELF.getSymbolNameByIndex$(eLF, n3);
                Integer n5 = ELF.resolveSymbol$(eLF, string);
                if (n5 == null) break;
                ELF.writeIntLE$(eLF, eLF.memory, n, n5 + n4);
                if (!eLF.midlet.debug) break;
                eLF.midlet.print("Reloc: " + String.valueOf(string) + " -> " + String.valueOf(ELF.toHex$(eLF, n5)) + " at " + String.valueOf(ELF.toHex$(eLF, n)), eLF.stdout, eLF.id, eLF.scope);
                break;
            }
            case 23: {
                int n6 = ELF.readIntLE$(eLF, eLF.memory, n);
                ELF.writeIntLE$(eLF, eLF.memory, n, n6 + n4);
                break;
            }
        }
    }

    static void setupLazyBinding$(ELF eLF, int n, int n2, int n3) throws  {
        int n4 = ELF.setupResolverStub$(eLF, n3);
        if (n4 != 0) {
            ELF.writeIntLE$(eLF, eLF.memory, n, n4);
            Hashtable<String, Constable> hashtable = new Hashtable<String, Constable>();
            hashtable.put("symIndex", new Integer(n2));
            hashtable.put("gotOffset", new Integer(n));
            hashtable.put("resolved", Boolean.FALSE);
            eLF.pltEntries.put("plt_".concat(String.valueOf(n3)), hashtable);
            if (eLF.midlet.debug) {
                eLF.midlet.print("Lazy binding: slot " + String.valueOf(n3) + " at GOT " + String.valueOf(ELF.toHex$(eLF, n)), eLF.stdout, eLF.id, eLF.scope);
            }
        }
    }

    static int setupResolverStub$(ELF eLF, int n) throws  {
        if (eLF.pltBase == 0) {
            eLF.pltBase = ELF.findFreeMemoryRegion$(eLF, 4096);
            if (eLF.pltBase == 0) {
                return 0;
            }
        }
        int n2 = eLF.pltBase + n * 16;
        ELF.writeIntLE$(eLF, eLF.memory, n2, -450891772);
        int n3 = ELF.setupResolverTrampoline$(eLF);
        ELF.writeIntLE$(eLF, eLF.memory, n2 + 4, n3 + n * 8);
        return n2;
    }

    static int setupResolverTrampoline$(ELF eLF) throws  {
        if (eLF.resolverCodeAddr == 0) {
            eLF.resolverCodeAddr = ELF.findFreeMemoryRegion$(eLF, 256);
            if (eLF.resolverCodeAddr == 0) {
                return 0;
            }
            ELF.writeIntLE$(eLF, eLF.memory, eLF.resolverCodeAddr, -382910449);
            ELF.writeIntLE$(eLF, eLF.memory, eLF.resolverCodeAddr + 4, -442564604);
            int n = ELF.setupResolveFunction$(eLF);
            int n2 = n - (eLF.resolverCodeAddr + 8 + 8) >> 2 & 0xFFFFFF;
            ELF.writeIntLE$(eLF, eLF.memory, eLF.resolverCodeAddr + 8, 0xEB000000 | n2);
            ELF.writeIntLE$(eLF, eLF.memory, eLF.resolverCodeAddr + 12, -390250481);
            ELF.writeIntLE$(eLF, eLF.memory, eLF.resolverCodeAddr + 16, -516948208);
            ELF.writeIntLE$(eLF, eLF.memory, eLF.resolverCodeAddr + 20, 0);
        }
        return eLF.resolverCodeAddr;
    }

    static int setupResolveFunction$(ELF eLF) throws  {
        if (eLF.resolveFuncAddr == 0) {
            eLF.resolveFuncAddr = ELF.findFreeMemoryRegion$(eLF, 128);
            if (eLF.resolveFuncAddr == 0) {
                return 0;
            }
            ELF.writeIntLE$(eLF, eLF.memory, eLF.resolveFuncAddr, -382910464);
            ELF.writeIntLE$(eLF, eLF.memory, eLF.resolveFuncAddr + 4, -442564604);
            int n = ELF.setupPLTResolverHandler$(eLF);
            int n2 = n - (eLF.resolveFuncAddr + 8 + 8) >> 2 & 0xFFFFFF;
            ELF.writeIntLE$(eLF, eLF.memory, eLF.resolveFuncAddr + 8, 0xEB000000 | n2);
            ELF.writeIntLE$(eLF, eLF.memory, eLF.resolveFuncAddr + 12, -390250496);
            ELF.writeIntLE$(eLF, eLF.memory, eLF.resolveFuncAddr + 16, -516948194);
            ELF.writeIntLE$(eLF, eLF.memory, eLF.resolveFuncAddr + 20, 0);
        }
        return eLF.resolveFuncAddr;
    }

    static int setupPLTResolverHandler$(ELF eLF) throws  {
        if (!eLF.elfInfo.containsKey("plt_resolver_handler")) {
            int n = ELF.findFreeMemoryRegion$(eLF, 64);
            if (n == 0) {
                return 0;
            }
            eLF.elfInfo.put("plt_resolver_handler", new Integer(n));
            if (!eLF.globalSymbols.containsKey("__plt_resolver")) {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("addr", new Integer(n));
                hashtable.put("type", "plt_resolver");
                eLF.globalSymbols.put("__plt_resolver", hashtable);
            }
        }
        return (Integer)eLF.elfInfo.get("plt_resolver_handler");
    }

    static void processPLTResolverCall$(ELF eLF, int n, int n2) throws  {
        int n3 = ELF.resolvePLTSymbol$(eLF, n2);
        if (n3 != 0) {
            eLF.registers[0] = n3;
        }
    }

    static String getSymbolNameByIndex$(ELF eLF, int n) throws  {
        Enumeration enumeration = eLF.dynamicSymbols.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (n2 == n) {
                return string;
            }
            ++n2;
        }
        return null;
    }

    static int resolvePLTSymbol$(ELF eLF, int n) throws  {
        String string = "plt_".concat(String.valueOf(n));
        if (!eLF.pltEntries.containsKey(string)) {
            return 0;
        }
        Hashtable hashtable = (Hashtable)eLF.pltEntries.get(string);
        int n2 = (Integer)hashtable.get("symIndex");
        int n3 = (Integer)hashtable.get("gotOffset");
        String string2 = ELF.getSymbolNameByIndex$(eLF, n2);
        Integer n4 = ELF.resolveSymbol$(eLF, string2);
        if (n4 != null) {
            ELF.writeIntLE$(eLF, eLF.memory, n3, n4);
            hashtable.put("resolved", Boolean.TRUE);
            if (eLF.midlet.debug) {
                eLF.midlet.print("Resolved: " + String.valueOf(string2) + " -> " + String.valueOf(ELF.toHex$(eLF, n4)), eLF.stdout, eLF.id, eLF.scope);
            }
            return n4;
        }
        return 0;
    }

    static Integer resolveSymbol$(ELF eLF, String string) throws  {
        Hashtable hashtable;
        int n;
        if (eLF.dynamicSymbols.containsKey(string) && (n = ((Integer)(hashtable = (Hashtable)eLF.dynamicSymbols.get(string)).get("value")).intValue()) != 0) {
            return new Integer(n);
        }
        int n2 = 0;
        while (n2 < eLF.loadedLibraries.size()) {
            String string2 = (String)eLF.loadedLibraries.elementAt(n2);
            Hashtable hashtable2 = (Hashtable)eLF.globalSymbols.get(string2);
            if (hashtable2 != null && hashtable2.containsKey(string)) {
                Object v = hashtable2.get(string);
                if (v instanceof Hashtable) {
                    return new Integer((Integer)((Hashtable)v).get("value"));
                }
                if (v instanceof Integer) {
                    return (Integer)v;
                }
            }
            ++n2;
        }
        if (string.startsWith("sys_")) {
            return new Integer(ELF.createSyscallStub$(eLF, string));
        }
        return null;
    }

    static void setupPLTGOT$(ELF eLF) throws  {
        if (eLF.pltGotAddr == 0) {
            return;
        }
        ELF.writeIntLE$(eLF, eLF.memory, eLF.pltGotAddr, eLF.dynamicSectionAddr);
        ELF.writeIntLE$(eLF, eLF.memory, eLF.pltGotAddr + 4, 0);
        ELF.writeIntLE$(eLF, eLF.memory, eLF.pltGotAddr + 8, eLF.resolveFuncAddr);
    }

    static void setupCRTStack$(ELF eLF) throws  {
        int n = eLF.registers[13];
        ELF.writeIntLE$(eLF, eLF.memory, n - 4, 0);
        ELF.writeIntLE$(eLF, eLF.memory, n - 8, 0);
        n -= 8;
        Vector<String> vector = new Vector<String>();
        vector.addElement("PATH=/bin");
        vector.addElement("USER=".concat(String.valueOf(eLF.id == 0 ? "root" : eLF.midlet.username)));
        vector.addElement("HOME=/home");
        vector.addElement("TERM=vt100");
        Enumeration enumeration = eLF.midlet.attributes.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)eLF.midlet.attributes.get(enumeration.nextElement()));
        }
        int n2 = n - (vector.size() + 1) * 4;
        int n3 = 0;
        while (n3 < vector.size()) {
            String string = (String)vector.elementAt(n3);
            byte[] byArray = string.getBytes();
            n -= byArray.length + 1;
            int n4 = 0;
            while (n4 < byArray.length) {
                eLF.memory[n + n4] = byArray[n4];
                ++n4;
            }
            eLF.memory[n + byArray.length] = 0;
            ELF.writeIntLE$(eLF, eLF.memory, n2 + n3 * 4, n);
            ++n3;
        }
        ELF.writeIntLE$(eLF, eLF.memory, n2 + vector.size() * 4, 0);
        n = n2;
        Vector<Object> vector2 = new Vector<Object>();
        int n5 = 0;
        while (n5 < eLF.args.size()) {
            vector2.addElement(eLF.args.get(new Double(n5)));
            ++n5;
        }
        if (vector2.size() == 0) {
            vector2.addElement("program");
        }
        n5 = n - (vector2.size() + 1) * 4;
        int n6 = 0;
        while (n6 < vector2.size()) {
            String string = (String)vector2.elementAt(n6);
            byte[] byArray = string.getBytes();
            n -= byArray.length + 1;
            int n7 = 0;
            while (n7 < byArray.length) {
                eLF.memory[n + n7] = byArray[n7];
                ++n7;
            }
            eLF.memory[n + byArray.length] = 0;
            ELF.writeIntLE$(eLF, eLF.memory, n5 + n6 * 4, n);
            ++n6;
        }
        ELF.writeIntLE$(eLF, eLF.memory, n5 + vector2.size() * 4, 0);
        n = n5;
        ELF.writeIntLE$(eLF, eLF.memory, n -= 4, vector2.size());
        eLF.elfInfo.put("argc", new Integer(vector2.size()));
        if (vector2.size() > 0) {
            eLF.elfInfo.put("argv0", vector2.elementAt(0));
        }
        eLF.registers[13] = n;
        if (eLF.midlet.debug) {
            eLF.midlet.print("Stack setup: SP=".concat(String.valueOf(ELF.toHex$(eLF, eLF.registers[13]))), eLF.stdout, eLF.id, eLF.scope);
            eLF.midlet.print("argc=".concat(String.valueOf(vector2.size())), eLF.stdout, eLF.id, eLF.scope);
            n6 = 0;
            while (n6 < vector2.size()) {
                eLF.midlet.print("argv[" + String.valueOf(n6) + "]=" + String.valueOf(vector2.elementAt(n6)), eLF.stdout, eLF.id, eLF.scope);
                ++n6;
            }
        }
    }

    static void handlePLTCall$(ELF eLF, int n) throws  {
        int n2 = (n - eLF.pltBase) / 16;
        if (n2 >= 0) {
            Hashtable hashtable;
            String string = "plt_".concat(String.valueOf(n2));
            if (eLF.pltEntries.containsKey(string) && !((Boolean)(hashtable = (Hashtable)eLF.pltEntries.get(string)).get("resolved")).booleanValue()) {
                ELF.resolvePLTSymbol$(eLF, n2);
            }
            int n3 = eLF.pltGotAddr + 12 + n2 * 4;
            int n4 = ELF.readIntLE$(eLF, eLF.memory, n3);
            eLF.registers[14] = eLF.pc;
            eLF.pc = n4;
            if (eLF.midlet.debug) {
                eLF.midlet.print("PLT call via slot " + String.valueOf(n2) + " to " + String.valueOf(ELF.toHex$(eLF, n4)), eLF.stdout, eLF.id, eLF.scope);
            }
        }
    }

    public void dumpDynamicInfo(Object object) throws  {
        this.midlet.print("=== Dynamic Linking Info ===", object, this.id, this.scope);
        this.midlet.print("PLT/GOT: ".concat(String.valueOf(ELF.toHex$(this, this.pltGotAddr))), object, this.id, this.scope);
        this.midlet.print("PLT Base: ".concat(String.valueOf(ELF.toHex$(this, this.pltBase))), object, this.id, this.scope);
        this.midlet.print("GOT Base: ".concat(String.valueOf(ELF.toHex$(this, this.gotBase))), object, this.id, this.scope);
        this.midlet.print("\nLoaded Libraries (".concat(String.valueOf(this.loadedLibraries.size())).concat("):"), object, this.id, this.scope);
        int n = 0;
        while (n < this.loadedLibraries.size()) {
            this.midlet.print("  ".concat(String.valueOf(this.loadedLibraries.elementAt(n))), object, this.id, this.scope);
            ++n;
        }
        this.midlet.print("\nDynamic Symbols (".concat(String.valueOf(this.dynamicSymbols.size())).concat("):"), object, this.id, this.scope);
        Enumeration enumeration = this.dynamicSymbols.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements() && n2 < 20) {
            String string = (String)enumeration.nextElement();
            Hashtable hashtable = (Hashtable)this.dynamicSymbols.get(string);
            int n3 = (Integer)hashtable.get("value");
            this.midlet.print("  " + String.valueOf(string) + " -> " + String.valueOf(ELF.toHex$(this, n3)), object, this.id, this.scope);
            ++n2;
        }
    }

    static int createSimpleStub$(ELF eLF, int n) throws  {
        int n2 = ELF.findFreeMemoryRegion$(eLF, n);
        if (n2 == 0) {
            return 0;
        }
        ELF.writeIntLE$(eLF, eLF.memory, n2, -476053504);
        ELF.writeIntLE$(eLF, eLF.memory, n2 + 4, -516948194);
        return n2;
    }

    static int createSyscallStub$(ELF eLF, String string) throws  {
        int n = ELF.findFreeMemoryRegion$(eLF, 32);
        if (n == 0) {
            return 0;
        }
        int n2 = ELF.mapSyscallName$(eLF, string);
        ELF.writeIntLE$(eLF, eLF.memory, n, 0xEF000000 | n2 & 0xFFFFFF);
        ELF.writeIntLE$(eLF, eLF.memory, n + 4, -516948194);
        return n;
    }

    static int mapSyscallName$(ELF eLF, String string) throws  {
        if (string.equals("exit") || string.indexOf("exit") != -1) {
            return 1;
        }
        if (string.equals("write") || string.indexOf("write") != -1) {
            return 4;
        }
        if (string.equals("read") || string.indexOf("read") != -1) {
            return 3;
        }
        if (string.equals("open") || string.indexOf("open") != -1) {
            return 5;
        }
        if (string.equals("close") || string.indexOf("close") != -1) {
            return 6;
        }
        if (string.equals("brk") || string.indexOf("brk") != -1) {
            return 45;
        }
        if (string.equals("fork") || string.indexOf("fork") != -1) {
            return 2;
        }
        if (string.equals("execve") || string.indexOf("exec") != -1) {
            return 11;
        }
        return 0;
    }

    static void handleSyscall$(ELF eLF, int n) throws  {
        if (eLF.midlet.debug && n != 78 && n != 20) {
            eLF.midlet.print("Syscall " + String.valueOf(n) + " (R7=" + String.valueOf(eLF.registers[7]) + ")", eLF.stdout, eLF.id, eLF.scope);
        }
        int n2 = eLF.pc;
        switch (n) {
            case 2: {
                ELF.handleFork$(eLF);
                break;
            }
            case 4: {
                ELF.handleWrite$(eLF);
                break;
            }
            case 3: {
                ELF.handleRead$(eLF);
                break;
            }
            case 5: {
                ELF.handleOpen$(eLF);
                break;
            }
            case 6: {
                ELF.handleClose$(eLF);
                break;
            }
            case 8: {
                ELF.handleCreat$(eLF);
                break;
            }
            case 13: {
                ELF.handleTime$(eLF);
                break;
            }
            case 12: {
                ELF.handleChdir$(eLF);
                break;
            }
            case 1: {
                ELF.handleExit$(eLF);
                break;
            }
            case 20: {
                ELF.handleGetpid$(eLF);
                break;
            }
            case 37: {
                ELF.handleKill$(eLF);
                break;
            }
            case 183: {
                ELF.handleGetcwd$(eLF);
                break;
            }
            case 45: {
                ELF.handleBrk$(eLF);
                break;
            }
            case 78: {
                ELF.handleGettimeofday$(eLF);
                break;
            }
            case 64: {
                ELF.handleGetppid$(eLF);
                break;
            }
            case 199: {
                ELF.handleGetuid$(eLF);
                break;
            }
            case 201: {
                ELF.handleGetuid$(eLF);
                break;
            }
            case 11: {
                ELF.handleExecve$(eLF);
                break;
            }
            case 39: {
                ELF.handleMkdir$(eLF);
                break;
            }
            case 40: {
                ELF.handleRmdir$(eLF);
                break;
            }
            case 106: {
                ELF.handleStat$(eLF);
                break;
            }
            case 108: {
                ELF.handleFstat$(eLF);
                break;
            }
            case 54: {
                ELF.handleIoctl$(eLF);
                break;
            }
            case 140: {
                ELF.handleGetpriority$(eLF);
                break;
            }
            case 141: {
                ELF.handleSetpriority$(eLF);
                break;
            }
            case 19: {
                ELF.handleLseek$(eLF);
                break;
            }
            case 217: {
                ELF.handleGetdents$(eLF);
                break;
            }
            case 41: {
                ELF.handleDup$(eLF);
                break;
            }
            case 63: {
                ELF.handleDup2$(eLF);
                break;
            }
            case 10: {
                ELF.handleUnlink$(eLF);
                break;
            }
            case 192: {
                ELF.handleMmap$(eLF);
                break;
            }
            case 91: {
                ELF.handleMunmap$(eLF);
                break;
            }
            case 125: {
                ELF.handleMprotect$(eLF);
                break;
            }
            case 163: {
                ELF.handleMremap$(eLF);
                break;
            }
            case 240: {
                ELF.handleFutex$(eLF);
                break;
            }
            case 158: {
                ELF.handleSchedYield$(eLF);
                break;
            }
            case 122: {
                ELF.handleUname$(eLF);
                break;
            }
            case 55: {
                ELF.handleFcntl$(eLF);
                break;
            }
            case 93: {
                ELF.handleFtruncate$(eLF);
                break;
            }
            case 92: {
                ELF.handleTruncate$(eLF);
                break;
            }
            case 191: {
                ELF.handleGetrlimit$(eLF);
                break;
            }
            case 0: {
                int n3;
                eLF.registers[7] = n3 = eLF.registers[0];
                eLF.registers[0] = eLF.registers[1];
                eLF.registers[1] = eLF.registers[2];
                eLF.registers[2] = eLF.registers[3];
                ELF.handleSyscall$(eLF, n3);
                break;
            }
            case 281: {
                ELF.handleSocket$(eLF);
                break;
            }
            case 283: {
                ELF.handleConnect$(eLF);
                break;
            }
            case 289: {
                ELF.handleSend$(eLF);
                break;
            }
            case 291: {
                ELF.handleRecv$(eLF);
                break;
            }
            case 282: {
                ELF.handleBind$(eLF);
                break;
            }
            case 284: {
                ELF.handleListen$(eLF);
                break;
            }
            case 285: {
                ELF.handleAccept$(eLF);
                break;
            }
            case 293: {
                ELF.handleShutdown$(eLF);
                break;
            }
            case 294: {
                ELF.handleSetsockopt$(eLF);
                break;
            }
            case 295: {
                ELF.handleGetsockopt$(eLF);
                break;
            }
            case 290: {
                ELF.handleSendto$(eLF);
                break;
            }
            case 292: {
                ELF.handleRecvfrom$(eLF);
                break;
            }
            case 286: {
                ELF.handleGetsockname$(eLF);
                break;
            }
            case 287: {
                ELF.handleGetpeername$(eLF);
                break;
            }
            case 48: {
                ELF.handleSignal$(eLF);
                break;
            }
            case 67: {
                ELF.handleSigaction$(eLF);
                break;
            }
            case 96: {
                ELF.handleSetjmp$(eLF);
                break;
            }
            case 97: {
                ELF.handleLongjmp$(eLF);
                break;
            }
            case 224: {
                ELF.handleGettid$(eLF);
                break;
            }
            case 162: {
                ELF.handleNanosleep$(eLF);
                break;
            }
            case 42: {
                eLF.registers[0] = -38;
                break;
            }
            case 142: {
                ELF.handleSelect$(eLF);
                break;
            }
            case 168: {
                ELF.handlePoll$(eLF);
                break;
            }
            case 118: {
                ELF.handleFsync$(eLF);
                break;
            }
            default: {
                eLF.registers[0] = -38;
                if (!eLF.midlet.debug) break;
                eLF.midlet.print("Unimplemented syscall: ".concat(String.valueOf(n)), eLF.stdout, eLF.id, eLF.scope);
                break;
            }
        }
    }

    static void handleFork$(ELF eLF) throws  {
        eLF.registers[0] = -1;
    }

    static void handleExecve$(ELF eLF) throws  {
        Object object;
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        if (n < 0 || n >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n + n4 < eLF.memory.length && eLF.memory[n + n4] != 0 && n4 < 256) {
            stringBuffer.append((char)(eLF.memory[n + n4] & 0xFF));
            ++n4;
        }
        String string = stringBuffer.toString();
        Vector<String> vector = new Vector<String>();
        if (n2 != 0) {
            int n5 = ELF.readIntLE$(eLF, eLF.memory, n2);
            int n6 = 0;
            while (n5 != 0 && n6 < 64) {
                object = new StringBuffer();
                int n7 = 0;
                while (n5 + n7 < eLF.memory.length && eLF.memory[n5 + n7] != 0 && n7 < 256) {
                    ((StringBuffer)object).append((char)(eLF.memory[n5 + n7] & 0xFF));
                    ++n7;
                }
                vector.addElement(((StringBuffer)object).toString());
                n5 = ELF.readIntLE$(eLF, eLF.memory, n2 += 4);
                ++n6;
            }
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        n4 = 1;
        while (n4 < vector.size()) {
            if (n4 > 1) {
                stringBuffer2.append(" ");
            }
            stringBuffer2.append((String)vector.elementAt(n4));
            ++n4;
        }
        try {
            int n8;
            InputStream inputStream = eLF.midlet.getInputStream(string, eLF.scope);
            if (inputStream == null) {
                eLF.registers[0] = -2;
                return;
            }
            object = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n8 = inputStream.read(byArray)) != -1) {
                ((ByteArrayOutputStream)object).write(byArray, 0, n8);
            }
            byte[] byArray2 = ((ByteArrayOutputStream)object).toByteArray();
            ((ByteArrayOutputStream)object).close();
            Hashtable hashtable = new Hashtable();
            if (eLF.midlet.isPureText(byArray2)) {
                String string2 = new String(byArray2, "UTF-8");
                Process process = new Process(eLF.midlet, "lua ".concat(String.valueOf(string)).trim(), eLF.midlet.joinpath(string, eLF.scope), eLF.midlet.getUser(eLF.id), eLF.id, eLF.midlet.genpid(), eLF.stdout, eLF.scope);
                process.lua.run(string, string2, hashtable);
                eLF.registers[0] = 0;
            } else {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                Process process = new Process(eLF.midlet, "elf", eLF.midlet.joinpath(string, eLF.scope), eLF.midlet.getUser(eLF.id), eLF.id, eLF.midlet.genpid(), eLF.stdout, hashtable, eLF.scope);
                if (process.elf.load(byteArrayInputStream)) {
                    process.elf.run();
                    eLF.registers[0] = 0;
                } else {
                    eLF.registers[0] = -8;
                }
            }
        }
        catch (Exception exception) {
            eLF.registers[0] = -1;
        }
    }

    static void handleGetpriority$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        eLF.registers[0] = n2 == 0 ? eLF.proc.priority : -22;
    }

    static void handleSetpriority$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        if (n2 == 0) {
            eLF.proc.priority = n3;
            eLF.registers[0] = 0;
        } else {
            eLF.registers[0] = -22;
        }
    }

    static void handleSignal$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        if (n <= 0 || n >= 32) {
            eLF.registers[0] = -1;
            return;
        }
        int n3 = eLF.signalHandlers[n];
        eLF.signalHandlers[n] = n2;
        eLF.registers[0] = n3;
    }

    static void handleSignal$(ELF eLF, int n) throws  {
        block9: {
            int n2;
            block8: {
                if (n <= 0 || n >= 32) {
                    return;
                }
                n2 = eLF.signalHandlers[n];
                if (n2 != 0) break block8;
                switch (n) {
                    case 11: {
                        eLF.running = false;
                        if (eLF.midlet.debug) {
                            eLF.midlet.print("Segmentation fault", eLF.stdout, eLF.id, eLF.scope);
                            break;
                        }
                        break block9;
                    }
                    case 2: {
                        eLF.running = false;
                        break;
                    }
                }
                break block9;
            }
            if (n2 == 1) {
                return;
            }
            if (n2 != 0) {
                ELF.pushSignalFrame$(eLF, n);
                eLF.pc = n2;
            }
        }
    }

    static void handleSigaction$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        if (n <= 0 || n >= 32) {
            eLF.registers[0] = -22;
            return;
        }
        if (n3 != 0 && n3 + 12 <= eLF.memory.length) {
            ELF.writeIntLE$(eLF, eLF.memory, n3, eLF.signalHandlers[n]);
            ELF.writeIntLE$(eLF, eLF.memory, n3 + 4, 0);
            ELF.writeIntLE$(eLF, eLF.memory, n3 + 8, 0);
        }
        if (n2 != 0 && n2 + 4 <= eLF.memory.length) {
            int n4;
            eLF.signalHandlers[n] = n4 = ELF.readIntLE$(eLF, eLF.memory, n2);
        }
        eLF.registers[0] = 0;
    }

    static void handleKill$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        String string = String.valueOf(n);
        if (!eLF.midlet.sys.containsKey(string)) {
            eLF.registers[0] = -3;
            return;
        }
        if (eLF.id != 0 && !string.equals(eLF.pid)) {
            eLF.registers[0] = -1;
            return;
        }
        Object v = eLF.midlet.sys.get(string);
        if (n2 == 9 || n2 == 15) {
            Hashtable hashtable;
            if (v instanceof Hashtable && (hashtable = (Hashtable)v).containsKey("elf")) {
                ELF eLF2 = (ELF)hashtable.get("elf");
                eLF2.kill();
            }
            eLF.midlet.sys.remove(string);
            eLF.registers[0] = 0;
            return;
        }
        if (n2 == 2 || n2 == 18 || n2 == 19) {
            Hashtable hashtable;
            if (v instanceof Hashtable && (hashtable = (Hashtable)v).containsKey("elf")) {
                ELF eLF3 = (ELF)hashtable.get("elf");
            }
            eLF.registers[0] = 0;
            return;
        }
        eLF.registers[0] = n2 == 0 ? 0 : -22;
    }

    static void handleExit$(ELF eLF) throws  {
        int n = eLF.registers[0];
        eLF.running = false;
        ELF.cleanup$(eLF);
    }

    static void cleanup$(ELF eLF) throws  {
        Serializable serializable;
        Object k;
        Enumeration enumeration = eLF.fileDescriptors.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            if (!(k instanceof Integer) || (Integer)(serializable = (Integer)k) < 3) continue;
            Object v = eLF.fileDescriptors.get(serializable);
            try {
                if (v instanceof InputStream) {
                    ((InputStream)v).close();
                    continue;
                }
                if (!(v instanceof OutputStream)) continue;
                ((OutputStream)v).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        enumeration = eLF.socketDescriptors.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            serializable = (Hashtable)eLF.socketDescriptors.get(k);
            if (((Hashtable)serializable).containsKey("connection")) {
                try {
                    ((StreamConnection)((Hashtable)serializable).get("connection")).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!((Hashtable)serializable).containsKey("server")) continue;
            try {
                ((StreamConnectionNotifier)((Hashtable)serializable).get("server")).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        eLF.fileDescriptors.clear();
        eLF.socketDescriptors.clear();
        eLF.allocatedBlocks.clear();
        eLF.instructionCache.clear();
        eLF.jmpBufs.clear();
        eLF.memoryMappings.removeAllElements();
    }

    static void handleGetpid$(ELF eLF) throws  {
        try {
            int n;
            eLF.registers[0] = n = Integer.parseInt(eLF.pid);
        }
        catch (NumberFormatException numberFormatException) {
            eLF.registers[0] = 1;
        }
    }

    static void handleGetppid$(ELF eLF) throws  {
        eLF.registers[0] = 1;
    }

    static void handleGetuid$(ELF eLF) throws  {
        eLF.registers[0] = eLF.id;
    }

    static void handleGettid$(ELF eLF) throws  {
        eLF.registers[0] = eLF.id;
    }

    static void handleMmap$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        int n4 = eLF.registers[3];
        int n5 = ELF.getSyscallParam$(eLF, 4);
        int n6 = ELF.getSyscallParam$(eLF, 5);
        if (eLF.midlet.debug) {
            eLF.midlet.print("mmap: addr=" + String.valueOf(ELF.toHex$(eLF, n)) + " length=" + String.valueOf(n2) + " prot=" + String.valueOf(n3) + " flags=" + String.valueOf(ELF.toHex$(eLF, n4)) + " fd=" + String.valueOf(n5) + " offset=" + String.valueOf(n6), eLF.stdout, eLF.id, eLF.scope);
        }
        if (n2 <= 0) {
            eLF.registers[0] = -22;
            return;
        }
        n2 = n2 + 4095 & ~4095;
        if (n == 0 && (n = ELF.findFreeMemoryRegion$(eLF, n2)) == 0) {
            eLF.registers[0] = -12;
            return;
        }
        if (!ELF.isMemoryRegionFree$(eLF, n, n2)) {
            eLF.registers[0] = -12;
            return;
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("addr", new Integer(n));
        hashtable.put("length", new Integer(n2));
        hashtable.put("prot", new Integer(n3));
        hashtable.put("flags", new Integer(n4));
        hashtable.put("fd", new Integer(n5));
        hashtable.put("offset", new Integer(n6));
        eLF.memoryMappings.addElement(hashtable);
        if ((n4 & 0x20) != 0) {
            int n7 = 0;
            while (n7 < n2 && n + n7 < eLF.memory.length) {
                eLF.memory[n + n7] = 0;
                ++n7;
            }
        }
        eLF.registers[0] = n;
    }

    static void handleMunmap$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = 0;
        while (n3 < eLF.memoryMappings.size()) {
            Hashtable hashtable = (Hashtable)eLF.memoryMappings.elementAt(n3);
            int n4 = (Integer)hashtable.get("addr");
            int n5 = (Integer)hashtable.get("length");
            if (n >= n4 && n < n4 + n5) {
                int n6 = 0;
                while (n6 < n5 && n4 + n6 < eLF.memory.length) {
                    eLF.memory[n4 + n6] = 0;
                    ++n6;
                }
                eLF.memoryMappings.removeElementAt(n3);
                eLF.registers[0] = 0;
                return;
            }
            ++n3;
        }
        eLF.registers[0] = -22;
    }

    static void handleMprotect$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        int n4 = 0;
        while (n4 < eLF.memoryMappings.size()) {
            Hashtable hashtable = (Hashtable)eLF.memoryMappings.elementAt(n4);
            int n5 = (Integer)hashtable.get("addr");
            int n6 = (Integer)hashtable.get("length");
            if (n >= n5 && n < n5 + n6) {
                hashtable.put("prot", new Integer(n3));
                eLF.registers[0] = 0;
                return;
            }
            ++n4;
        }
        eLF.registers[0] = -22;
    }

    static void handleMremap$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        int n4 = eLF.registers[3];
        int n5 = ELF.getSyscallParam$(eLF, 4);
        if (eLF.midlet.debug) {
            eLF.midlet.print("mremap: old=" + String.valueOf(ELF.toHex$(eLF, n)) + " oldsize=" + String.valueOf(n2) + " newsize=" + String.valueOf(n3) + " flags=" + String.valueOf(n4) + " newaddr=" + String.valueOf(ELF.toHex$(eLF, n5)), eLF.stdout, eLF.id, eLF.scope);
        }
        if (n5 == 0) {
            int n6 = 0;
            while (n6 < eLF.memoryMappings.size()) {
                Hashtable hashtable = (Hashtable)eLF.memoryMappings.elementAt(n6);
                int n7 = (Integer)hashtable.get("addr");
                int n8 = (Integer)hashtable.get("length");
                if (n7 == n && n8 == n2 && ELF.isMemoryRegionFree$(eLF, n7 + n8, n3 - n2)) {
                    hashtable.put("length", new Integer(n3));
                    eLF.registers[0] = n7;
                    return;
                }
                ++n6;
            }
        }
        eLF.registers[0] = -12;
    }

    static void handleBrk$(ELF eLF) throws  {
        int n = eLF.registers[0];
        if (n == 0) {
            eLF.registers[0] = eLF.heapEnd;
            return;
        }
        if (n < eLF.heapStart) {
            eLF.registers[0] = -1;
            return;
        }
        if ((n = n + 4095 & ~4095) > eLF.memory.length) {
            eLF.registers[0] = -12;
            return;
        }
        if (n < eLF.heapEnd) {
            Vector<Integer> vector = new Vector<Integer>();
            Enumeration enumeration = eLF.allocatedBlocks.keys();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                Integer n3 = (Integer)eLF.allocatedBlocks.get(n2);
                if (n2 + n3 <= n) continue;
                vector.addElement(n2);
            }
            int n4 = 0;
            while (n4 < vector.size()) {
                eLF.allocatedBlocks.remove(vector.elementAt(n4));
                ++n4;
            }
        }
        eLF.registers[0] = eLF.heapEnd = n;
    }

    static void handleSetjmp$(ELF eLF) throws  {
        int n = eLF.registers[0];
        if (n + 48 > eLF.memory.length) {
            eLF.registers[0] = -14;
            return;
        }
        int n2 = 0;
        while (n2 < 16) {
            ELF.writeIntLE$(eLF, eLF.memory, n + n2 * 4, eLF.registers[n2]);
            ++n2;
        }
        ELF.writeIntLE$(eLF, eLF.memory, n + 64, eLF.pc);
        n2 = eLF.nextJmpBufId++;
        eLF.jmpBufs.put(new Integer(n2), new Integer(n));
        eLF.registers[0] = 0;
    }

    static void handleLongjmp$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        if (n + 48 > eLF.memory.length) {
            eLF.running = false;
            return;
        }
        int n3 = 0;
        while (n3 < 16) {
            eLF.registers[n3] = ELF.readIntLE$(eLF, eLF.memory, n + n3 * 4);
            ++n3;
        }
        eLF.pc = ELF.readIntLE$(eLF, eLF.memory, n + 64);
        eLF.registers[0] = n2 == 0 ? 1 : n2;
    }

    static void handleIoctl$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        Integer n4 = new Integer(n);
        if (!eLF.fileDescriptors.containsKey(n4) && n != 0 && n != 1 && n != 2) {
            eLF.registers[0] = -9;
            return;
        }
        switch (n2) {
            case 21505: 
            case 21523: {
                if (n3 >= 0 && n3 + 8 < eLF.memory.length) {
                    int n5 = 0;
                    while (n5 < 8) {
                        eLF.memory[n3 + n5] = 0;
                        ++n5;
                    }
                    eLF.memory[n3] = 80;
                    eLF.memory[n3 + 2] = 25;
                }
                eLF.registers[0] = 0;
                break;
            }
            case 21506: 
            case 21524: {
                eLF.registers[0] = 0;
                break;
            }
            case 21531: {
                Object v;
                int n6 = 0;
                if (n == 0) {
                    n6 = 0;
                } else if (eLF.fileDescriptors.containsKey(n4) && (v = eLF.fileDescriptors.get(n4)) instanceof InputStream) {
                    try {
                        n6 = ((InputStream)v).available();
                    }
                    catch (Exception exception) {
                        n6 = 0;
                    }
                }
                if (n3 >= 0 && n3 + 4 < eLF.memory.length) {
                    ELF.writeIntLE$(eLF, eLF.memory, n3, n6);
                }
                eLF.registers[0] = 0;
                break;
            }
            default: {
                eLF.registers[0] = -25;
                break;
            }
        }
    }

    static void handleTime$(ELF eLF) throws  {
        long l = System.currentTimeMillis() / (long)1000;
        eLF.registers[0] = (int)l;
        int n = eLF.registers[1];
        if (n != 0 && n >= 0 && n + 3 < eLF.memory.length) {
            ELF.writeIntLE$(eLF, eLF.memory, n, (int)l);
        }
    }

    static void handleGettimeofday$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        long l = System.currentTimeMillis();
        int n3 = (int)(l / (long)1000);
        int n4 = (int)(l % (long)1000 * (long)1000);
        if (n != 0 && n >= 0 && n + 7 < eLF.memory.length) {
            ELF.writeIntLE$(eLF, eLF.memory, n, n3);
            ELF.writeIntLE$(eLF, eLF.memory, n + 4, n4);
        }
        eLF.registers[0] = 0;
    }

    static void handleMkdir$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        if (n < 0 || n >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n + n3 < eLF.memory.length && eLF.memory[n + n3] != 0 && n3 < 256) {
            stringBuffer.append((char)(eLF.memory[n + n3] & 0xFF));
            ++n3;
        }
        String string = stringBuffer.toString();
        if (string.startsWith("/mnt/")) {
            try {
                FileConnection fileConnection = (FileConnection)Connector.open((String)"file:///".concat(String.valueOf(string.substring(5))), (int)3);
                if (fileConnection.exists()) {
                    fileConnection.close();
                    eLF.registers[0] = -17;
                    return;
                }
                fileConnection.mkdir();
                fileConnection.close();
                eLF.registers[0] = 0;
            }
            catch (Exception exception) {
                eLF.registers[0] = -1;
            }
        } else {
            eLF.registers[0] = -38;
            return;
        }
    }

    static void handleRmdir$(ELF eLF) throws  {
        int n = eLF.registers[0];
        if (n < 0 || n >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n + n2 < eLF.memory.length && eLF.memory[n + n2] != 0 && n2 < 256) {
            stringBuffer.append((char)(eLF.memory[n + n2] & 0xFF));
            ++n2;
        }
        String string = stringBuffer.toString();
        if (string.startsWith("/mnt/")) {
            try {
                FileConnection fileConnection = (FileConnection)Connector.open((String)"file:///".concat(String.valueOf(string.substring(5))), (int)3);
                if (!fileConnection.exists()) {
                    fileConnection.close();
                    eLF.registers[0] = -2;
                    return;
                }
                if (!fileConnection.isDirectory()) {
                    fileConnection.close();
                    eLF.registers[0] = -20;
                    return;
                }
                Enumeration enumeration = fileConnection.list();
                if (enumeration != null && enumeration.hasMoreElements()) {
                    fileConnection.close();
                    eLF.registers[0] = -39;
                    return;
                }
                fileConnection.delete();
                fileConnection.close();
                eLF.registers[0] = 0;
            }
            catch (Exception exception) {
                eLF.registers[0] = -1;
            }
        } else {
            eLF.registers[0] = -38;
        }
    }

    static void handleGetcwd$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        String string = (String)eLF.scope.get("PWD");
        if (string == null) {
            string = "/home/";
        }
        byte[] byArray = string.getBytes();
        int n3 = Math.min(byArray.length, n2 - 1);
        int n4 = 0;
        while (n4 < n3 && n + n4 < eLF.memory.length) {
            eLF.memory[n + n4] = byArray[n4];
            ++n4;
        }
        if (n + n3 < eLF.memory.length) {
            eLF.memory[n + n3] = 0;
        }
        eLF.registers[0] = n;
    }

    static void handleChdir$(ELF eLF) throws  {
        int n = eLF.registers[0];
        if (n < 0 || n >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n + n2 < eLF.memory.length && eLF.memory[n + n2] != 0 && n2 < 256) {
            stringBuffer.append((char)(eLF.memory[n + n2] & 0xFF));
            ++n2;
        }
        String string = stringBuffer.toString();
        if (string.equals("") || string.equals(".")) {
            eLF.registers[0] = 0;
            return;
        }
        String string2 = string;
        if (!string.startsWith("/")) {
            String string3 = (String)eLF.scope.get("PWD");
            if (string3 == null) {
                string3 = "/home/";
            }
            string2 = String.valueOf(string3).concat(String.valueOf(string3.endsWith("/") ? "" : "/")).concat(String.valueOf(string));
        }
        if (!string2.endsWith("/")) {
            string2 = String.valueOf(string2).concat("/");
        }
        boolean bl = false;
        if (string2.equals("/home/")) {
            bl = true;
        } else if (string2.startsWith("/mnt/")) {
            try {
                FileConnection fileConnection = (FileConnection)Connector.open((String)"file:///".concat(String.valueOf(string2.substring(5))), (int)1);
                bl = fileConnection.exists() && fileConnection.isDirectory();
                fileConnection.close();
            }
            catch (Exception exception) {
                bl = false;
            }
        } else if (eLF.midlet.fs.containsKey(string2)) {
            bl = true;
        }
        if (bl) {
            eLF.scope.put("PWD", string2);
            eLF.registers[0] = 0;
        } else {
            eLF.registers[0] = -2;
        }
    }

    static void handleGetdents$(ELF eLF) throws  {
        int n;
        Object object;
        Object object2;
        int n2 = eLF.registers[0];
        int n3 = eLF.registers[1];
        int n4 = eLF.registers[2];
        if (n3 < 0 || n3 >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        Integer n5 = new Integer(n2);
        if (!eLF.fileDescriptors.containsKey(n5) && n2 != 0 && n2 != 1 && n2 != 2) {
            eLF.registers[0] = -9;
            return;
        }
        String string = null;
        if (eLF.fileDescriptors.containsKey(n5)) {
            object2 = eLF.fileDescriptors.get(n5);
            if (object2 instanceof String) {
                string = (String)object2;
            } else if (object2 instanceof StringBuffer && eLF.fileDescriptors.containsKey(object = String.valueOf(n2).concat(":path"))) {
                string = (String)eLF.fileDescriptors.get(object);
            }
        }
        if (string == null) {
            eLF.registers[0] = -20;
            return;
        }
        object2 = eLF.midlet.joinpath(string, eLF.scope);
        if (!((String)object2).endsWith("/")) {
            object2 = String.valueOf(object2).concat("/");
        }
        object = new Vector();
        try {
            String[] stringArray;
            if (((String)object2).equals("/tmp/")) {
                stringArray = eLF.midlet.tmp.keys();
                while (stringArray.hasMoreElements()) {
                    ((Vector)object).addElement((String)stringArray.nextElement());
                }
            } else if (((String)object2).equals("/mnt/")) {
                stringArray = FileSystemRegistry.listRoots();
                while (stringArray.hasMoreElements()) {
                    ((Vector)object).addElement((String)stringArray.nextElement());
                }
            } else if (((String)object2).startsWith("/mnt/")) {
                stringArray = (FileConnection)Connector.open((String)"file:///".concat(String.valueOf(((String)object2).substring(5))), (int)1);
                Enumeration enumeration = stringArray.list();
                while (enumeration.hasMoreElements()) {
                    ((Vector)object).addElement((String)enumeration.nextElement());
                }
                stringArray.close();
            } else if (((String)object2).equals("/bin/") || ((String)object2).equals("/etc/") || ((String)object2).equals("/lib/")) {
                int n6;
                OpenTTY cfr_ignored_0 = eLF.midlet;
                stringArray = OpenTTY.loadRMS("OpenRMS", ((String)object2).equals("/bin/") ? 3 : (((String)object2).equals("/etc/") ? 5 : 4));
                int n7 = 0;
                while ((n = stringArray.indexOf("[\u0001BEGIN:", n7)) != -1 && (n6 = stringArray.indexOf("\u0001]", n)) != -1) {
                    ((Vector)object).addElement(stringArray.substring(n + "[\u0001BEGIN:".length(), n6));
                    n7 = stringArray.indexOf("[\u0001END\u0001]", n6);
                    if (n7 != -1) {
                        n7 += "[\u0001END\u0001]".length();
                        continue;
                    }
                    break;
                }
            } else if (((String)object2).equals("/home/") && (stringArray = RecordStore.listRecordStores()) != null) {
                int n8 = 0;
                while (n8 < stringArray.length) {
                    ((Vector)object).addElement(stringArray[n8]);
                    ++n8;
                }
            }
            if (eLF.midlet.fs.containsKey(object2)) {
                stringArray = (Vector)eLF.midlet.fs.get(object2);
                int n9 = 0;
                while (n9 < stringArray.size()) {
                    ((Vector)object).addElement(stringArray.elementAt(n9));
                    ++n9;
                }
            }
        }
        catch (Exception exception) {
            eLF.registers[0] = -1;
            return;
        }
        int n10 = 0;
        int n11 = 0;
        n = 0;
        while (n < ((Vector)object).size()) {
            String string2 = (String)((Vector)object).elementAt(n);
            byte[] byArray = string2.getBytes();
            int n12 = byArray.length;
            int n13 = 10 + n12 + 1;
            if (n10 + n13 > n4 || n3 + n10 + n13 > eLF.memory.length) break;
            ELF.writeIntLE$(eLF, eLF.memory, n3 + n10, n + 1);
            ELF.writeIntLE$(eLF, eLF.memory, n3 + n10 + 4, n10 + n13);
            ELF.writeShortLE$(eLF, eLF.memory, n3 + n10 + 8, (short)n13);
            int n14 = 0;
            while (n14 < n12) {
                eLF.memory[n3 + n10 + 10 + n14] = byArray[n14];
                ++n14;
            }
            eLF.memory[n3 + n10 + 10 + n12] = 0;
            n10 += n13;
            ++n11;
            ++n;
        }
        eLF.registers[0] = n11 == 0 ? 0 : n10;
    }

    static void handleDup$(ELF eLF) throws  {
        int n = eLF.registers[0];
        Integer n2 = new Integer(n);
        if (!eLF.fileDescriptors.containsKey(n2) && n != 0 && n != 1 && n != 2) {
            eLF.registers[0] = -9;
            return;
        }
        int n3 = eLF.nextFd++;
        while (eLF.fileDescriptors.containsKey(new Integer(n3))) {
            ++n3;
        }
        if (n == 0 || n == 1 || n == 2) {
            eLF.fileDescriptors.put(new Integer(n3), n == 1 || n == 2 ? eLF.stdout : null);
        } else {
            eLF.fileDescriptors.put(new Integer(n3), eLF.fileDescriptors.get(n2));
        }
        eLF.registers[0] = n3;
    }

    static void handleDup2$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        Integer n3 = new Integer(n);
        if (!eLF.fileDescriptors.containsKey(n3) && n != 0 && n != 1 && n != 2) {
            eLF.registers[0] = -9;
            return;
        }
        Integer n4 = new Integer(n2);
        if (eLF.fileDescriptors.containsKey(n4)) {
            Object v = eLF.fileDescriptors.get(n4);
            try {
                if (v instanceof InputStream) {
                    ((InputStream)v).close();
                } else if (v instanceof OutputStream) {
                    ((OutputStream)v).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            eLF.fileDescriptors.remove(n4);
        }
        if (n == 0 || n == 1 || n == 2) {
            eLF.fileDescriptors.put(n4, n == 1 || n == 2 ? eLF.stdout : null);
        } else {
            eLF.fileDescriptors.put(n4, eLF.fileDescriptors.get(n3));
        }
        eLF.registers[0] = n2;
    }

    static void handleCreat$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        eLF.registers[1] = 577;
        eLF.registers[2] = n2;
        ELF.handleOpen$(eLF);
    }

    static void handleOpen$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        if (n < 0 || n >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n + n4 < eLF.memory.length && eLF.memory[n + n4] != 0 && n4 < 256) {
            stringBuffer.append((char)(eLF.memory[n + n4] & 0xFF));
            ++n4;
        }
        String string = stringBuffer.toString();
        try {
            boolean bl = (n2 & 0) == 0 || (n2 & 2) == 2;
            boolean bl2 = (n2 & 1) == 1 || (n2 & 2) == 2;
            boolean bl3 = (n2 & 0x40) != 0;
            boolean bl4 = (n2 & 0x400) != 0;
            boolean bl5 = (n2 & 0x200) != 0;
            boolean bl6 = (n2 & 0x10000) != 0;
            String string2 = eLF.midlet.joinpath(string, eLF.scope);
            if (bl6) {
                Integer n5;
                boolean bl7 = false;
                if (string2.equals("/") || string2.equals("/home/") || string2.equals("/tmp/") || string2.equals("/bin/") || string2.equals("/etc/") || string2.equals("/lib/")) {
                    bl7 = true;
                } else if (string2.startsWith("/mnt/")) {
                    try {
                        n5 = (FileConnection)Connector.open((String)"file:///".concat(String.valueOf(string2.substring(5))), (int)1);
                        bl7 = n5.exists() && n5.isDirectory();
                        n5.close();
                    }
                    catch (Exception exception) {
                        bl7 = false;
                    }
                } else if (eLF.midlet.fs.containsKey(string2)) {
                    bl7 = true;
                }
                if (bl7) {
                    n5 = new Integer(eLF.nextFd++);
                    eLF.fileDescriptors.put(n5, string2);
                    eLF.registers[0] = n5;
                } else {
                    eLF.registers[0] = -20;
                }
                return;
            }
            if (bl) {
                InputStream inputStream = eLF.midlet.getInputStream(string2, eLF.scope);
                if (inputStream != null) {
                    Integer n6 = new Integer(eLF.nextFd++);
                    eLF.fileDescriptors.put(n6, inputStream);
                    eLF.registers[0] = n6;
                } else if (bl3) {
                    eLF.midlet.write(string2, "", eLF.id, eLF.scope);
                    InputStream inputStream2 = eLF.midlet.getInputStream(string2, eLF.scope);
                    if (inputStream2 != null) {
                        Integer n7 = new Integer(eLF.nextFd++);
                        eLF.fileDescriptors.put(n7, inputStream2);
                        eLF.registers[0] = n7;
                    } else {
                        eLF.registers[0] = -1;
                    }
                } else {
                    eLF.registers[0] = -2;
                }
            } else if (bl2) {
                Object object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                if (bl4 && !bl5 && (object = eLF.midlet.getInputStream(string2, eLF.scope)) != null) {
                    int n8;
                    while ((n8 = ((InputStream)object).read()) != -1) {
                        byteArrayOutputStream.write(n8);
                    }
                    ((InputStream)object).close();
                }
                object = new Integer(eLF.nextFd++);
                eLF.fileDescriptors.put(object, byteArrayOutputStream);
                eLF.registers[0] = (Integer)object;
                eLF.fileDescriptors.put(String.valueOf(object).concat(":path"), string2);
            } else {
                eLF.registers[0] = -1;
            }
        }
        catch (Exception exception) {
            eLF.registers[0] = -1;
        }
    }

    static void handleClose$(ELF eLF) throws  {
        int n = eLF.registers[0];
        Integer n2 = new Integer(n);
        if (n == 0 || n == 1 || n == 2) {
            eLF.registers[0] = 0;
            return;
        }
        if (eLF.fileDescriptors.containsKey(n2)) {
            Object v = eLF.fileDescriptors.get(n2);
            try {
                if (v instanceof InputStream) {
                    ((InputStream)v).close();
                } else if (v instanceof OutputStream) {
                    OutputStream outputStream = (OutputStream)v;
                    outputStream.close();
                    if (v instanceof ByteArrayOutputStream) {
                        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)v;
                        String string = String.valueOf(n).concat(":path");
                        if (eLF.fileDescriptors.containsKey(string)) {
                            String string2 = (String)eLF.fileDescriptors.get(string);
                            byte[] byArray = byteArrayOutputStream.toByteArray();
                            eLF.midlet.write(string2, byArray, eLF.id, eLF.scope);
                        }
                    }
                }
                eLF.fileDescriptors.remove(new Integer(n));
                eLF.fileDescriptors.remove(String.valueOf(n).concat(":path"));
                eLF.registers[0] = 0;
            }
            catch (Exception exception) {
                eLF.registers[0] = -1;
            }
        } else {
            eLF.registers[0] = -1;
        }
    }

    static void handleUnlink$(ELF eLF) throws  {
        int n = eLF.registers[0];
        if (n < 0 || n >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n + n2 < eLF.memory.length && eLF.memory[n + n2] != 0 && n2 < 256) {
            stringBuffer.append((char)(eLF.memory[n + n2] & 0xFF));
            ++n2;
        }
        String string = stringBuffer.toString();
        int n3 = eLF.midlet.deleteFile(string, eLF.id, eLF.scope);
        switch (n3) {
            case 0: {
                eLF.registers[0] = 0;
                break;
            }
            case 2: {
                eLF.registers[0] = -22;
                break;
            }
            case 5: {
                eLF.registers[0] = -2;
                break;
            }
            case 13: {
                eLF.registers[0] = -13;
                break;
            }
            case 127: {
                eLF.registers[0] = -2;
                break;
            }
            default: {
                eLF.registers[0] = -1;
                break;
            }
        }
    }

    static void handleRead$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        if (n3 <= 0 || n2 < 0 || n2 >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        Integer n4 = new Integer(n);
        if (n == 0) {
            eLF.registers[0] = 0;
        } else if (eLF.fileDescriptors.containsKey(n4)) {
            Object v = eLF.fileDescriptors.get(n4);
            if (v instanceof InputStream) {
                try {
                    InputStream inputStream = (InputStream)v;
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n3 && n2 + n6 < eLF.memory.length) {
                        int n7 = inputStream.read();
                        if (n7 == -1) break;
                        eLF.memory[n2 + n6] = (byte)n7;
                        ++n5;
                        ++n6;
                    }
                    eLF.registers[0] = n5;
                }
                catch (Exception exception) {
                    eLF.registers[0] = -1;
                }
            } else {
                eLF.registers[0] = -1;
            }
        } else {
            eLF.registers[0] = -1;
        }
    }

    static void handleWrite$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        if (n3 <= 0 || n2 < 0 || n2 >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        Integer n4 = new Integer(n);
        if (n == 1 || n == 2) {
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = 0;
            while (n5 < n3 && n2 + n5 < eLF.memory.length) {
                stringBuffer.append((char)(eLF.memory[n2 + n5] & 0xFF));
                ++n5;
            }
            eLF.midlet.print(stringBuffer.toString(), eLF.stdout, eLF.id, eLF.scope);
            eLF.registers[0] = n3;
        } else if (eLF.fileDescriptors.containsKey(n4)) {
            Object v = eLF.fileDescriptors.get(n4);
            if (v instanceof OutputStream) {
                try {
                    OutputStream outputStream = (OutputStream)v;
                    int n6 = 0;
                    while (n6 < n3 && n2 + n6 < eLF.memory.length) {
                        outputStream.write(eLF.memory[n2 + n6]);
                        ++n6;
                    }
                    outputStream.flush();
                    eLF.registers[0] = n3;
                }
                catch (Exception exception) {
                    eLF.registers[0] = -1;
                }
            } else if (v instanceof StringBuffer) {
                StringBuffer stringBuffer = (StringBuffer)v;
                int n7 = 0;
                while (n7 < n3 && n2 + n7 < eLF.memory.length) {
                    stringBuffer.append((char)(eLF.memory[n2 + n7] & 0xFF));
                    ++n7;
                }
                eLF.registers[0] = n3;
            } else {
                eLF.registers[0] = -1;
            }
        } else {
            eLF.registers[0] = -1;
        }
    }

    static void handleStat$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        if (n < 0 || n >= eLF.memory.length || n2 < 0 || n2 >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n + n3 < eLF.memory.length && eLF.memory[n + n3] != 0 && n3 < 256) {
            stringBuffer.append((char)(eLF.memory[n + n3] & 0xFF));
            ++n3;
        }
        String string = stringBuffer.toString();
        n3 = 0;
        while (n3 < 108) {
            if (n2 + n3 < eLF.memory.length) {
                eLF.memory[n2 + n3] = 0;
            }
            ++n3;
        }
        int n4 = 0;
        n4 = string.endsWith("/") ? (n4 |= 0x41FD) : (n4 |= 0x81A4);
        ELF.writeIntLE$(eLF, eLF.memory, n2 + 16, n4);
        int n5 = 0;
        if (!string.endsWith("/")) {
            try {
                InputStream inputStream = eLF.midlet.getInputStream(string, eLF.scope);
                if (inputStream != null) {
                    int n6 = inputStream.available();
                    if (n6 > 0) {
                        n5 = n6;
                    }
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ELF.writeIntLE$(eLF, eLF.memory, n2 + 44, n5);
        eLF.registers[0] = 0;
    }

    static void handleFstat$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        if (n2 < 0 || n2 >= eLF.memory.length) {
            eLF.registers[0] = -1;
            return;
        }
        int n3 = 0;
        while (n3 < 108) {
            if (n2 + n3 < eLF.memory.length) {
                eLF.memory[n2 + n3] = 0;
            }
            ++n3;
        }
        Integer n4 = new Integer(n);
        if (n == 0 || n == 1 || n == 2) {
            ELF.writeIntLE$(eLF, eLF.memory, n2 + 16, 8192);
        } else if (eLF.fileDescriptors.containsKey(n4)) {
            Object v = eLF.fileDescriptors.get(n4);
            if (v instanceof InputStream || v instanceof OutputStream) {
                ELF.writeIntLE$(eLF, eLF.memory, n2 + 16, 33188);
                try {
                    if (v instanceof InputStream) {
                        int n5 = ((InputStream)v).available();
                        ELF.writeIntLE$(eLF, eLF.memory, n2 + 44, n5);
                    }
                }
                catch (Exception exception) {}
            } else {
                ELF.writeIntLE$(eLF, eLF.memory, n2 + 16, 8192);
            }
        } else {
            eLF.registers[0] = -9;
            return;
        }
        eLF.registers[0] = 0;
    }

    static void handleLseek$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        Integer n4 = new Integer(n);
        if (!eLF.fileDescriptors.containsKey(n4) && n != 0 && n != 1 && n != 2) {
            eLF.registers[0] = -9;
            return;
        }
        eLF.registers[0] = 0;
    }

    static void handleFsync$(ELF eLF) throws  {
        int n = eLF.registers[0];
        Integer n2 = new Integer(n);
        if (!eLF.fileDescriptors.containsKey(n2) && n != 0 && n != 1 && n != 2) {
            eLF.registers[0] = -9;
            return;
        }
        try {
            Object v;
            if (eLF.fileDescriptors.containsKey(n2) && (v = eLF.fileDescriptors.get(n2)) instanceof OutputStream) {
                ((OutputStream)v).flush();
            }
            eLF.registers[0] = 0;
        }
        catch (Exception exception) {
            eLF.registers[0] = -1;
        }
    }

    static void handleSocket$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        if (n != 2) {
            eLF.registers[0] = -97;
            return;
        }
        if (n2 != 1 && n2 != 2) {
            eLF.registers[0] = -22;
            return;
        }
        try {
            String string = n2 == 1 ? "tcp" : "udp";
            String string2 = "socket://0.0.0.0";
            StreamConnectionNotifier streamConnectionNotifier = null;
            if (n2 == 1) {
                streamConnectionNotifier = (StreamConnectionNotifier)Connector.open((String)"socket://:0");
            }
            int n4 = eLF.nextFd++;
            Hashtable<String, Constable> hashtable = new Hashtable<String, Constable>();
            hashtable.put("type", new Integer(n2));
            hashtable.put("protocol", new Integer(n3));
            hashtable.put("server", (Constable)streamConnectionNotifier);
            hashtable.put("connected", Boolean.FALSE);
            eLF.socketDescriptors.put(new Integer(n4), hashtable);
            eLF.fileDescriptors.put(new Integer(n4), null);
            eLF.registers[0] = n4;
        }
        catch (Exception exception) {
            eLF.registers[0] = -1;
        }
    }

    static void handleConnect$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        Integer n4 = new Integer(n);
        if (!eLF.socketDescriptors.containsKey(n4)) {
            eLF.registers[0] = -9;
            return;
        }
        Hashtable hashtable = (Hashtable)eLF.socketDescriptors.get(n4);
        int n5 = (Integer)hashtable.get("type");
        if (n2 + 16 > eLF.memory.length) {
            eLF.registers[0] = -14;
            return;
        }
        short s = ELF.readShortLE$(eLF, eLF.memory, n2);
        short s2 = ELF.readShortLE$(eLF, eLF.memory, n2 + 2);
        byte[] byArray = new byte[4];
        int n6 = 0;
        while (n6 < 4) {
            byArray[n6] = eLF.memory[n2 + 4 + n6];
            ++n6;
        }
        if (s != 2) {
            eLF.registers[0] = -97;
            return;
        }
        String string = String.valueOf(byArray[0] & 0xFF) + "." + String.valueOf(byArray[1] & 0xFF) + "." + String.valueOf(byArray[2] & 0xFF) + "." + String.valueOf(byArray[3] & 0xFF);
        String string2 = String.valueOf(s2 & 0xFFFF);
        try {
            SocketConnection socketConnection = (SocketConnection)Connector.open((String)("socket://" + String.valueOf(string) + ":" + String.valueOf(string2)));
            hashtable.put("connection", socketConnection);
            hashtable.put("connected", Boolean.TRUE);
            if (n5 == 1) {
                InputStream inputStream = socketConnection.openInputStream();
                OutputStream outputStream = socketConnection.openOutputStream();
                eLF.fileDescriptors.put(n4, inputStream);
                hashtable.put("outputStream", outputStream);
            }
            eLF.registers[0] = 0;
        }
        catch (Exception exception) {
            eLF.registers[0] = -111;
        }
    }

    static void handleSend$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        int n4 = eLF.registers[3];
        Integer n5 = new Integer(n);
        if (!eLF.socketDescriptors.containsKey(n5)) {
            eLF.registers[0] = -9;
            return;
        }
        Hashtable hashtable = (Hashtable)eLF.socketDescriptors.get(n5);
        if (!((Boolean)hashtable.get("connected")).booleanValue()) {
            eLF.registers[0] = -107;
            return;
        }
        try {
            OutputStream outputStream = (OutputStream)hashtable.get("outputStream");
            if (outputStream == null) {
                eLF.registers[0] = -9;
                return;
            }
            byte[] byArray = new byte[n3];
            int n6 = 0;
            while (n6 < n3 && n2 + n6 < eLF.memory.length) {
                byArray[n6] = eLF.memory[n2 + n6];
                ++n6;
            }
            outputStream.write(byArray);
            outputStream.flush();
            eLF.registers[0] = n3;
        }
        catch (Exception exception) {
            eLF.registers[0] = -32;
        }
    }

    static void handleSendto$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        int n4 = eLF.registers[3];
        int n5 = ELF.getSyscallParam$(eLF, 4);
        int n6 = ELF.getSyscallParam$(eLF, 5);
        ELF.handleSend$(eLF);
    }

    static void handleRecv$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        int n4 = eLF.registers[3];
        Integer n5 = new Integer(n);
        if (!eLF.socketDescriptors.containsKey(n5)) {
            eLF.registers[0] = -9;
            return;
        }
        Hashtable hashtable = (Hashtable)eLF.socketDescriptors.get(n5);
        if (!((Boolean)hashtable.get("connected")).booleanValue()) {
            eLF.registers[0] = -107;
            return;
        }
        try {
            InputStream inputStream = (InputStream)eLF.fileDescriptors.get(n5);
            if (inputStream == null) {
                eLF.registers[0] = -9;
                return;
            }
            int n6 = 0;
            int n7 = 0;
            while (n7 < n3 && n2 + n7 < eLF.memory.length) {
                int n8 = inputStream.read();
                if (n8 == -1) {
                    eLF.registers[0] = n6 == 0 ? 0 : n6;
                    return;
                }
                eLF.memory[n2 + n7] = (byte)n8;
                ++n6;
                ++n7;
            }
            eLF.registers[0] = n6;
        }
        catch (Exception exception) {
            eLF.registers[0] = -104;
        }
    }

    static void handleRecvfrom$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        int n4 = eLF.registers[3];
        int n5 = ELF.getSyscallParam$(eLF, 4);
        int n6 = ELF.getSyscallParam$(eLF, 5);
        ELF.handleRecv$(eLF);
    }

    static void handleSetsockopt$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        int n4 = eLF.registers[3];
        int n5 = ELF.getSyscallParam$(eLF, 4);
        eLF.registers[0] = 0;
    }

    static void handleGetsockopt$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        int n4 = eLF.registers[3];
        int n5 = ELF.getSyscallParam$(eLF, 4);
        eLF.registers[0] = 0;
    }

    static void handleBind$(ELF eLF) throws  {
        eLF.registers[0] = -1;
    }

    static void handleListen$(ELF eLF) throws  {
        eLF.registers[0] = -1;
    }

    static void handleAccept$(ELF eLF) throws  {
        eLF.registers[0] = -1;
    }

    static void handleShutdown$(ELF eLF) throws  {
        eLF.registers[0] = -1;
    }

    static void handleNanosleep$(ELF eLF) throws  {
        eLF.registers[0] = -1;
    }

    static void handleGetsockname$(ELF eLF) throws  {
        eLF.registers[0] = -1;
    }

    static void handleGetpeername$(ELF eLF) throws  {
        eLF.registers[0] = -1;
    }

    static void handleFutex$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        int n4 = eLF.registers[3];
        int n5 = ELF.getSyscallParam$(eLF, 4);
        int n6 = ELF.getSyscallParam$(eLF, 5);
        if (eLF.midlet.debug) {
            eLF.midlet.print("futex: uaddr=" + String.valueOf(ELF.toHex$(eLF, n)) + " op=" + String.valueOf(n2) + " val=" + String.valueOf(n3) + " timeout=" + String.valueOf(n4), eLF.stdout, eLF.id, eLF.scope);
        }
        switch (n2 & 0x7F) {
            case 0: {
                int n7 = ELF.readIntLE$(eLF, eLF.memory, n);
                if (n7 != n3) {
                    eLF.registers[0] = -11;
                    break;
                }
                Vector<Integer> vector = (Vector<Integer>)eLF.futexWaiters.get(new Integer(n));
                if (vector == null) {
                    vector = new Vector<Integer>();
                    eLF.futexWaiters.put(new Integer(n), vector);
                }
                vector.addElement(new Integer(eLF.id));
                eLF.registers[0] = 0;
                break;
            }
            case 1: {
                Vector vector = (Vector)eLF.futexWaiters.get(new Integer(n));
                if (vector != null) {
                    int n8 = Math.min(n3, vector.size());
                    int n9 = 0;
                    while (n9 < n8) {
                        vector.removeElementAt(0);
                        ++n9;
                    }
                    eLF.registers[0] = n8;
                    break;
                }
                eLF.registers[0] = 0;
                break;
            }
            default: {
                eLF.registers[0] = -38;
            }
        }
    }

    static void handleSchedYield$(ELF eLF) throws  {
        eLF.registers[0] = 0;
    }

    static void handleUname$(ELF eLF) throws  {
        int n = eLF.registers[0];
        if (n == 0 || n + 325 > eLF.memory.length) {
            eLF.registers[0] = -14;
            return;
        }
        String string = "Linux";
        String string2 = "opentty";
        String string3 = "3.2.0";
        String string4 = "#1 ".concat(String.valueOf(eLF.midlet.build));
        String string5 = "armv5tejl";
        String string6 = "";
        ELF.writeString$(eLF, eLF.memory, n, string, 65);
        ELF.writeString$(eLF, eLF.memory, n + 65, string2, 65);
        ELF.writeString$(eLF, eLF.memory, n + 130, string3, 65);
        ELF.writeString$(eLF, eLF.memory, n + 195, string4, 65);
        ELF.writeString$(eLF, eLF.memory, n + 260, string5, 65);
        ELF.writeString$(eLF, eLF.memory, n + 325, string6, 65);
        eLF.registers[0] = 0;
    }

    static void handleFcntl$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        Integer n4 = new Integer(n);
        if (!eLF.fileDescriptors.containsKey(n4) && n != 0 && n != 1 && n != 2) {
            eLF.registers[0] = -9;
            return;
        }
        switch (n2) {
            case 3: {
                eLF.registers[0] = 0;
                break;
            }
            case 4: {
                eLF.registers[0] = 0;
                break;
            }
            default: {
                eLF.registers[0] = -22;
            }
        }
    }

    static void handleFtruncate$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        eLF.registers[0] = 0;
    }

    static void handleTruncate$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        eLF.registers[0] = 0;
    }

    static void handleGetrlimit$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        if (n2 == 0 || n2 + 8 > eLF.memory.length) {
            eLF.registers[0] = -14;
            return;
        }
        long l = Integer.MAX_VALUE;
        long l2 = Integer.MAX_VALUE;
        switch (n) {
            case 3: {
                l2 = l = (long)0x800000;
                break;
            }
            case 6: {
                l2 = l = (long)eLF.memory.length;
                break;
            }
            case 7: {
                l = 0;
                l2 = 0;
                break;
            }
        }
        ELF.writeIntLE$(eLF, eLF.memory, n2, (int)l);
        ELF.writeIntLE$(eLF, eLF.memory, n2 + 4, (int)l2);
        eLF.registers[0] = 0;
    }

    static void checkPendingSignals$(ELF eLF) throws  {
    }

    static void pushSignalFrame$(ELF eLF, int n) throws  {
        int n2 = eLF.registers[13];
        int n3 = 0;
        while (n3 < 16) {
            ELF.writeIntLE$(eLF, eLF.memory, n2 -= 4, eLF.registers[n3]);
            ++n3;
        }
        ELF.writeIntLE$(eLF, eLF.memory, n2 -= 4, n);
        ELF.writeIntLE$(eLF, eLF.memory, n2 -= 4, eLF.pc);
        eLF.registers[13] = n2;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("sp", new Integer(n2));
        hashtable.put("old_pc", new Integer(eLF.pc));
        eLF.signalStack.addElement(hashtable);
    }

    static void handleSelect$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        int n4 = eLF.registers[3];
        int n5 = eLF.pc + 16;
        eLF.registers[0] = 0;
    }

    static void handlePoll$(ELF eLF) throws  {
        int n = eLF.registers[0];
        int n2 = eLF.registers[1];
        int n3 = eLF.registers[2];
        eLF.registers[0] = 0;
    }

    static int readIntLE$(ELF eLF, byte[] byArray, int n) throws  {
        if (n + 3 >= byArray.length || n < 0) {
            return 0;
        }
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    static short readShortLE$(ELF eLF, byte[] byArray, int n) throws  {
        if (n + 1 >= byArray.length || n < 0) {
            return 0;
        }
        return (short)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8);
    }

    static void writeIntLE$(ELF eLF, byte[] byArray, int n, int n2) throws  {
        if (n + 3 >= byArray.length || n < 0) {
            return;
        }
        byArray[n] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 3] = (byte)(n2 >> 24 & 0xFF);
    }

    static void writeShortLE$(ELF eLF, byte[] byArray, int n, short s) throws  {
        if (n + 1 >= byArray.length || n < 0) {
            return;
        }
        byArray[n] = (byte)(s & 0xFF);
        byArray[n + 1] = (byte)(s >> 8 & 0xFF);
    }

    static int rotateRight$(ELF eLF, int n, int n2) throws  {
        return n >>> (n2 &= 0x1F) | n << 32 - n2;
    }

    static int findFreeMemoryRegion$(ELF eLF, int n) throws  {
        int n2 = eLF.heapEnd;
        while (n2 + n < eLF.memory.length) {
            boolean bl = true;
            if (eLF.pltBase != 0 && n2 < eLF.pltBase + 4096 && n2 + n > eLF.pltBase) {
                bl = false;
                n2 = eLF.pltBase + 4096;
            }
            if (eLF.resolverCodeAddr != 0 && n2 < eLF.resolverCodeAddr + 256 && n2 + n > eLF.resolverCodeAddr) {
                bl = false;
                n2 = eLF.resolverCodeAddr + 256;
            }
            if (!bl) continue;
            n2 = n2 + 4095 & ~4095;
            return n2;
        }
        return 0;
    }

    static boolean isMemoryRegionFree$(ELF eLF, int n, int n2) throws  {
        int n3 = 0;
        while (n3 < eLF.memoryMappings.size()) {
            int n4;
            Hashtable hashtable = (Hashtable)eLF.memoryMappings.elementAt(n3);
            int n5 = (Integer)hashtable.get("addr");
            if (n < n5 + (n4 = ((Integer)hashtable.get("length")).intValue()) && n + n2 > n5) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    static int getSyscallParam$(ELF eLF, int n) throws  {
        if (n < 4) {
            return eLF.registers[n];
        }
        int n2 = eLF.registers[13];
        int n3 = 4 + (n - 4) * 4;
        if (n2 + n3 + 3 < eLF.memory.length && n2 + n3 >= 0) {
            return ELF.readIntLE$(eLF, eLF.memory, n2 + n3);
        }
        return 0;
    }

    static String readString$(ELF eLF, byte[] byArray, int n, int n2) throws  {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2 && n + n3 < byArray.length) {
            byte by = byArray[n + n3];
            if (by == 0) break;
            stringBuffer.append((char)(by & 0xFF));
            ++n3;
        }
        return stringBuffer.toString();
    }

    static void writeString$(ELF eLF, byte[] byArray, int n, String string, int n2) throws  {
        byte[] byArray2 = string.getBytes();
        int n3 = Math.min(byArray2.length, n2 - 1);
        int n4 = 0;
        while (n4 < n3) {
            byArray[n + n4] = byArray2[n4];
            ++n4;
        }
        byArray[n + n3] = 0;
    }

    static void debugMemoryAccess$(ELF eLF, int n, int n2, boolean bl, int n3) throws  {
        if (eLF.midlet.debug && n < 65536) {
            String string = bl ? "WRITE" : "READ";
            eLF.midlet.print("MEM " + String.valueOf(string) + " at " + String.valueOf(ELF.toHex$(eLF, n)) + " size=" + String.valueOf(n2) + String.valueOf(bl ? " value=".concat(String.valueOf(ELF.toHex$(eLF, n3))) : ""), eLF.stdout, eLF.id, eLF.scope);
        }
    }

    public ELF(OpenTTY openTTY, Hashtable hashtable, Object object, Hashtable hashtable2, int n, String string, Process process) throws  {
        this.midlet = openTTY;
        this.stdout = object;
        this.id = n;
        this.scope = hashtable2;
        this.proc = process;
        this.args = hashtable;
        this.pid = string == null ? openTTY.genpid() : string;
        this.memory = new byte[0x100000];
        this.registers = new int[16];
        this.fpuRegisters = new float[32];
        this.cpsr = 0;
        this.fpscr = 0;
        this.running = false;
        this.nextJmpBufId = 1;
        this.stackPointer = this.memory.length - 1024;
        this.jmpBufs = new Hashtable();
        this.socketDescriptors = new Hashtable();
        this.allocatedBlocks = new Hashtable();
        this.fileDescriptors = new Hashtable();
        this.nextFd = 3;
        this.heapEnd = this.heapStart = 0x200000;
        this.instructionCache = new Hashtable();
        this.cacheHits = 0;
        this.cacheMisses = 0;
        this.signalStack = new Vector();
        this.memoryMappings = new Vector();
        this.loadedLibraries = new Vector();
        this.elfInfo = new Hashtable();
        this.futexWaiters = new Hashtable();
        this.dynamicSymbols = new Hashtable();
        this.neededLibraries = new Hashtable();
        this.globalSymbols = new Hashtable();
        this.pltEntries = new Hashtable();
        this.pltGotAddr = 0;
        this.dynamicSectionAddr = 0;
        this.gotBase = 0;
        this.pltBase = 0;
        this.resolverCodeAddr = 0;
        this.resolveFuncAddr = 0;
        ELF.loadDefaultLibraries$(this);
        this.signalHandlers = new int[32];
        int n2 = 0;
        while (n2 < 32) {
            this.signalHandlers[n2] = 0;
            ++n2;
        }
        this.fileDescriptors.put(new Integer(1), object);
        this.fileDescriptors.put(new Integer(2), object);
    }
}

