/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Hashtable;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class OpenTTY
extends MIDlet
implements CommandListener {
    boolean app;
    String username = "";
    String version = "1.2";
    Hashtable aliases = new Hashtable();
    Display display = Display.getDisplay((MIDlet)this);
    Form form = new Form("OpenTTY ".concat(String.valueOf(this.version)));
    Command enterCommand = new Command("Send", 4, 1);
    Command helpCommand = new Command("Help", 1, 2);
    Command openCommand = new Command("Open", 1, 3);
    Command clearCommand = new Command("Clear", 1, 4);
    Command loginCommand = new Command("Login", 1, 5);
    Command executeCommand = new Command("Execute", 1, 6);
    TextField commandInput = new TextField("Command", "", 256, 0);
    StringItem output = new StringItem("", "Welcome to OpenTTY ".concat(String.valueOf(this.version)).concat("\nCopyright (C) 2024 - Mr. Lima\n"));

    public void startApp() throws  {
        if (!this.app) {
            this.form.append((Item)this.output);
            this.form.append((Item)this.commandInput);
            this.form.addCommand(this.enterCommand);
            this.form.addCommand(this.helpCommand);
            this.form.addCommand(this.openCommand);
            this.form.addCommand(this.clearCommand);
            this.form.addCommand(this.loginCommand);
            this.form.addCommand(this.executeCommand);
            this.form.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.form);
        }
    }

    public void pauseApp() throws  {
        this.app = true;
    }

    public void destroyApp(boolean bl) throws  {
    }

    public void commandAction(Command command, Displayable displayable) throws  {
        if (command == this.enterCommand) {
            OpenTTY.processCommand$(this, this.commandInput.getString());
            this.commandInput.setString("");
        } else if (command == this.clearCommand) {
            this.output.setText("");
        } else if (command == this.helpCommand) {
            OpenTTY.processCommand$(this, "help");
        } else if (command == this.executeCommand) {
            this.commandInput.setString("execute ");
        } else if (command == this.loginCommand) {
            this.commandInput.setString(String.valueOf(this.commandInput.getString()).concat("login "));
        } else if (command == this.openCommand) {
            this.commandInput.setString(String.valueOf(this.commandInput.getString()).concat("open "));
        }
    }

    static void processCommand$(OpenTTY openTTY, String string) throws  {
        string = string.trim();
        String string2 = OpenTTY.getCommand$(openTTY, string).toLowerCase();
        String string3 = OpenTTY.getArgument$(openTTY, string);
        if (openTTY.aliases.containsKey(string2)) {
            string2 = (String)openTTY.aliases.get(string2);
        }
        if (!string2.equals("")) {
            if (string2.equals("!")) {
                OpenTTY.echoCommand$(openTTY, "OpenTTY Java Edition");
            } else if (string2.equals("date")) {
                OpenTTY.dateCommand$(openTTY);
            } else if (string2.equals("lock")) {
                OpenTTY.lockCommand$(openTTY);
            } else if (string2.equals("login")) {
                OpenTTY.login$(openTTY, string3);
            } else if (string2.equals("exit")) {
                openTTY.notifyDestroyed();
            } else if (string2.equals("ping")) {
                OpenTTY.pingCommand$(openTTY, string3);
            } else if (string2.equals("curl")) {
                OpenTTY.curlCommand$(openTTY, string3);
            } else if (string2.equals("call")) {
                OpenTTY.callCommand$(openTTY, string3);
            } else if (string2.equals("echo")) {
                OpenTTY.echoCommand$(openTTY, string3);
            } else if (string2.equals("open")) {
                OpenTTY.openCommand$(openTTY, string3);
            } else if (string2.equals("uname")) {
                OpenTTY.unameCommand$(openTTY, string3);
            } else if (string2.equals("alias")) {
                OpenTTY.aliasCommand$(openTTY, string3);
            } else if (string2.equals("unalias")) {
                OpenTTY.unaliasCommand$(openTTY, string3);
            } else if (string2.equals("execute")) {
                OpenTTY.processCommand$(openTTY, string3);
            } else if (!string2.equals("true") && !string2.equals("false")) {
                if (string2.equals("help")) {
                    OpenTTY.echoCommand$(openTTY, OpenTTY.read$(openTTY, "/help.txt"));
                } else if (string2.equals("version")) {
                    OpenTTY.echoCommand$(openTTY, "OpenTTY ".concat(String.valueOf(openTTY.version)));
                } else if (string2.equals("ipconfig")) {
                    OpenTTY.curlCommand$(openTTY, "http://checkip.amazonaws.com");
                } else if (string2.equals("clear") || string2.equals("cls")) {
                    openTTY.output.setText("");
                } else if (string2.equals("locale")) {
                    OpenTTY.echoCommand$(openTTY, System.getProperty("microedition.locale"));
                } else if (string2.equals("hostname")) {
                    OpenTTY.echoCommand$(openTTY, System.getProperty("microedition.hostname"));
                } else if (string2.equals("logout")) {
                    if (openTTY.username.equals("")) {
                        OpenTTY.echoCommand$(openTTY, "logout: not logged");
                    } else {
                        openTTY.username = "";
                    }
                } else if (string2.equals("title")) {
                    if (string3.equals("")) {
                        openTTY.form.setTitle("OpenTTY ".concat(String.valueOf(openTTY.version)));
                    } else {
                        openTTY.form.setTitle(string3);
                    }
                } else if (string2.equals("sh")) {
                    openTTY.form.setTitle("OpenTTY ".concat(String.valueOf(openTTY.version)));
                    openTTY.output.setText("Welcome to OpenTTY ".concat(String.valueOf(openTTY.version)).concat("\nCopyright (C) 2024 - Mr. Lima\n"));
                } else if (string2.equals("whoami")) {
                    if (openTTY.username.equals("")) {
                        OpenTTY.echoCommand$(openTTY, "whoami: not logged");
                    } else {
                        OpenTTY.echoCommand$(openTTY, String.valueOf(openTTY.username).concat("@").concat(String.valueOf(System.getProperty("microedition.hostname"))));
                    }
                } else {
                    OpenTTY.echoCommand$(openTTY, String.valueOf(string2).concat(": unknown command"));
                }
            }
        }
    }

    static String getCommand$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    static String getArgument$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1).trim();
    }

    static String read$(OpenTTY openTTY, String string) throws  {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            InputStream inputStream = ((Object)((Object)openTTY)).getClass().getResourceAsStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            while ((n = inputStreamReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            inputStreamReader.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return iOException.getMessage();
        }
    }

    static void aliasCommand$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            OpenTTY.echoCommand$(openTTY, "Usage: alias <name> <command>");
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        openTTY.aliases.put(string2, string3);
    }

    static void unaliasCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: unalias <alias>");
            return;
        }
        if (openTTY.aliases.containsKey(string)) {
            openTTY.aliases.remove(string);
        } else {
            OpenTTY.echoCommand$(openTTY, "unalias: ".concat(String.valueOf(string)).concat(": not found"));
        }
    }

    static void dateCommand$(OpenTTY openTTY) throws  {
        OpenTTY.echoCommand$(openTTY, ((Object)new Date()).toString());
    }

    static void echoCommand$(OpenTTY openTTY, String string) throws  {
        openTTY.output.setText(String.valueOf(openTTY.output.getText()).concat("\n").concat(String.valueOf(string)));
    }

    static void unameCommand$(OpenTTY openTTY, String string) throws  {
        openTTY.output.setText(String.valueOf(openTTY.output.getText()) + "\n" + String.valueOf(System.getProperty("microedition.platform")) + " " + String.valueOf(System.getProperty("microedition.configuration")) + " " + String.valueOf(System.getProperty("microedition.profiles")));
    }

    static void callCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: call <phone>");
            return;
        }
        try {
            openTTY.platformRequest("tel:".concat(String.valueOf(string)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void openCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: open <url>");
            return;
        }
        try {
            openTTY.platformRequest(string);
        }
        catch (Exception exception) {
            OpenTTY.echoCommand$(openTTY, "open: ".concat(String.valueOf(string)).concat(": not found"));
        }
    }

    static void login$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: login <user>");
        } else if (openTTY.username.equals("")) {
            openTTY.username = string;
        } else {
            OpenTTY.echoCommand$(openTTY, "login: already logged");
        }
    }

    static void lockCommand$(OpenTTY openTTY) throws  {
        if (openTTY.username == null || openTTY.username.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "lock: not logged");
        } else {
            while (!openTTY.commandInput.getString().equals(openTTY.username)) {
            }
        }
    }

    static void curlCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: curl <url>");
            return;
        }
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            string = "http://".concat(String.valueOf(string));
        }
        new Thread(new OpenTTY$1(openTTY, string)).start();
    }

    static void pingCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: ping <url>");
            return;
        }
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            string = "http://".concat(String.valueOf(string));
        }
        new Thread(new OpenTTY$2(openTTY, string)).start();
    }
}

