/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class OpenTTY
extends MIDlet
implements CommandListener {
    boolean app;
    int currentIndex = 0;
    String path = "/";
    String version = "1.8.2";
    Hashtable paths = new Hashtable();
    Hashtable aliases = new Hashtable();
    Vector commandHistory = new Vector();
    Hashtable attributes = new Hashtable();
    String username = OpenTTY.loadRMS$(this, "OpenRMS", 1);
    String nanoContent = OpenTTY.loadRMS$(this, "nano", 1);
    Display display = Display.getDisplay((MIDlet)this);
    Form form = new Form("OpenTTY ".concat(String.valueOf(this.version)));
    Command enterCommand = new Command("Send", 4, 1);
    Command helpCommand = new Command("Help", 1, 2);
    Command nanoCommand = new Command("Nano", 1, 3);
    Command clearCommand = new Command("Clear", 1, 4);
    Command historyCommand = new Command("History", 1, 5);
    TextField commandInput = new TextField("Command", "", 256, 0);
    StringItem output = new StringItem("", "Welcome to OpenTTY ".concat(String.valueOf(this.version)).concat("\nCopyright (C) 2024 - Mr. Lima\n"));

    public void startApp() throws  {
        if (!this.app) {
            OpenTTY.mount$(this, OpenTTY.read$(this, "/java/bin/fstab"));
            this.commandInput.setLabel(String.valueOf(this.username) + " " + String.valueOf(this.path) + " $");
            this.attributes.put("PATCH", "Netman Update");
            this.attributes.put("VERSION", this.version);
            this.attributes.put("RELEASE", "beta");
            this.attributes.put("XVERSION", "0.4");
            this.attributes.put("TTY", "/java/optty1");
            this.attributes.put("HOSTNAME", "localhost");
            this.attributes.put("PORT", "4095");
            this.attributes.put("RESPONSE", "com.opentty.server");
            this.attributes.put("TYPE", System.getProperty("microedition.platform"));
            this.attributes.put("CONFIG", System.getProperty("microedition.configuration"));
            this.attributes.put("PROFILE", System.getProperty("microedition.profiles"));
            this.attributes.put("LOCALE", System.getProperty("microedition.locale"));
            this.attributes.put("OUTPUT", "");
            this.attributes.put("l", "\n");
            this.form.append((Item)this.output);
            this.form.append((Item)this.commandInput);
            this.form.addCommand(this.enterCommand);
            this.form.addCommand(this.helpCommand);
            this.form.addCommand(this.nanoCommand);
            this.form.addCommand(this.clearCommand);
            this.form.addCommand(this.historyCommand);
            this.form.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.form);
            OpenTTY.processCommand$(this, "run initd");
        }
    }

    public void pauseApp() throws  {
        this.app = true;
    }

    public void destroyApp(boolean bl) throws  {
        OpenTTY.writeRMS$(this, "nano", this.nanoContent);
    }

    public void commandAction(Command command, Displayable displayable) throws  {
        if (command == this.enterCommand) {
            String string = this.commandInput.getString().trim();
            if (!string.equals("")) {
                this.commandHistory.addElement(string);
            }
            this.commandInput.setString("");
            OpenTTY.processCommand$(this, string);
            this.commandInput.setLabel(String.valueOf(this.username) + " " + String.valueOf(this.path) + " $");
        } else if (command == this.clearCommand) {
            this.output.setText("");
        } else if (command == this.helpCommand) {
            OpenTTY.processCommand$(this, "help");
        } else if (command == this.historyCommand) {
            OpenTTY.showHistory$(this);
        } else if (command == this.nanoCommand) {
            OpenTTY.nano$(this);
        }
    }

    static void processCommand$(OpenTTY openTTY, String string) throws  {
        string = OpenTTY.env$(openTTY, string.trim());
        String string2 = OpenTTY.getCommand$(openTTY, string).toLowerCase();
        String string3 = OpenTTY.getArgument$(openTTY, string);
        if (openTTY.aliases.containsKey(string2)) {
            OpenTTY.processCommand$(openTTY, String.valueOf((String)openTTY.aliases.get(string2)).concat(String.valueOf(string3)));
            return;
        }
        if (!string2.equals("")) {
            if (string2.equals("netstat")) {
                OpenTTY.netstat$(openTTY);
            } else if (string2.equals("nc")) {
                OpenTTY.connect$(openTTY, string3);
            } else if (string2.equals("fw")) {
                OpenTTY.fwCommand$(openTTY, string3);
            } else if (string2.equals("ipconfig")) {
                OpenTTY.fwCommand$(openTTY, "ip");
            } else if (string2.equals("ping")) {
                OpenTTY.pingCommand$(openTTY, string3);
            } else if (string2.equals("curl")) {
                OpenTTY.curlCommand$(openTTY, string3);
            } else if (string2.equals("wget")) {
                OpenTTY.wgetCommand$(openTTY, string3);
            } else if (string2.equals("prscan")) {
                OpenTTY.portScanner$(openTTY, string3);
            } else if (string2.equals("server")) {
                OpenTTY.runServer$(openTTY, OpenTTY.env$(openTTY, "$PORT"));
            } else if (string2.equals("nano")) {
                OpenTTY.nano$(openTTY);
            } else if (string2.equals("pwd")) {
                OpenTTY.echoCommand$(openTTY, openTTY.path);
            } else if (string2.equals("rnano")) {
                openTTY.nanoContent = "";
            } else if (string2.equals("cd")) {
                OpenTTY.changeDisk$(openTTY, string3);
            } else if (string2.equals("install")) {
                OpenTTY.install$(openTTY, string3);
            } else if (string2.equals("load")) {
                OpenTTY.loadCommand$(openTTY, string3);
            } else if (string2.equals("raw")) {
                OpenTTY.echoCommand$(openTTY, openTTY.nanoContent);
            } else if (string2.equals("rraw")) {
                openTTY.output.setText(openTTY.nanoContent);
            } else if (string2.equals("getty")) {
                openTTY.nanoContent = openTTY.output.getText();
            } else if (string2.equals("json")) {
                OpenTTY.echoCommand$(openTTY, OpenTTY.parseJson$(openTTY, openTTY.nanoContent));
            } else if (string2.equals("pjnc")) {
                openTTY.nanoContent = OpenTTY.parseJson$(openTTY, openTTY.nanoContent);
            } else if (string2.equals("add")) {
                openTTY.nanoContent = String.valueOf(openTTY.nanoContent).concat("\n").concat(String.valueOf(string3));
            } else if (string2.equals("ls")) {
                OpenTTY.viewer$(openTTY, "Resources", OpenTTY.read$(openTTY, "/java/resources.txt"));
            } else if (string2.equals("html")) {
                OpenTTY.viewer$(openTTY, OpenTTY.extractTitle$(openTTY, openTTY.nanoContent), OpenTTY.html2text$(openTTY, openTTY.nanoContent));
            } else if (string2.equals("cat")) {
                if (string3.equals("")) {
                    OpenTTY.echoCommand$(openTTY, "Usage: cat <file>");
                } else if (string3.startsWith("/")) {
                    OpenTTY.echoCommand$(openTTY, OpenTTY.read$(openTTY, string3));
                } else {
                    OpenTTY.echoCommand$(openTTY, OpenTTY.read$(openTTY, String.valueOf(openTTY.path).concat("/").concat(String.valueOf(string3))));
                }
            } else if (string2.equals("get")) {
                if (string3.equals("")) {
                    OpenTTY.echoCommand$(openTTY, "Usage: get <file>");
                } else {
                    openTTY.nanoContent = string3.startsWith("/") ? OpenTTY.read$(openTTY, string3) : OpenTTY.read$(openTTY, String.valueOf(openTTY.path).concat("/").concat(String.valueOf(string3)));
                }
            } else if (string2.equals("mount")) {
                if (string3.equals("")) {
                    OpenTTY.echoCommand$(openTTY, "Usage: mount <drive>");
                } else if (string3.startsWith("/")) {
                    OpenTTY.mount$(openTTY, OpenTTY.read$(openTTY, string3));
                } else if (string3.equals("nano")) {
                    OpenTTY.mount$(openTTY, openTTY.nanoContent);
                } else {
                    OpenTTY.mount$(openTTY, OpenTTY.loadRMS$(openTTY, string3, 1));
                }
            } else if (string2.equals("unmount")) {
                openTTY.paths = new Hashtable();
            } else if (string2.equals("alias")) {
                OpenTTY.aliasCommand$(openTTY, string3);
            } else if (string2.equals("basename")) {
                OpenTTY.echoCommand$(openTTY, OpenTTY.basename$(openTTY, string3));
            } else if (string2.equals("call")) {
                OpenTTY.callCommand$(openTTY, string3);
            } else if (string2.equals("clear") || string2.equals("cls")) {
                openTTY.output.setText("");
            } else if (string2.equals("date")) {
                OpenTTY.echoCommand$(openTTY, ((Object)new Date()).toString());
            } else if (string2.equals("debug")) {
                OpenTTY.runScript$(openTTY, OpenTTY.read$(openTTY, "/scripts/debug.sh"));
            } else if (string2.equals("echo")) {
                OpenTTY.echoCommand$(openTTY, string3);
            } else if (string2.equals("exit")) {
                OpenTTY.writeRMS$(openTTY, "nano", openTTY.nanoContent);
                openTTY.notifyDestroyed();
            } else if (string2.equals("export")) {
                if (string3.equals("")) {
                    OpenTTY.echoCommand$(openTTY, "Usage: export <name>");
                } else {
                    openTTY.attributes.put(string3, "");
                }
            } else if (string2.equals("execute")) {
                OpenTTY.processCommand$(openTTY, string3);
            } else if (string2.equals("forget")) {
                openTTY.commandHistory = new Vector();
            } else if (string2.equals("hostname")) {
                OpenTTY.echoCommand$(openTTY, OpenTTY.env$(openTTY, "$HOSTNAME"));
            } else if (string2.equals("htop")) {
                OpenTTY.htopCommand$(openTTY);
            } else if (string2.equals("help")) {
                OpenTTY.viewer$(openTTY, "OpenTTY Help", OpenTTY.read$(openTTY, "/java/help.txt"));
            } else if (string2.equals("history")) {
                OpenTTY.showHistory$(openTTY);
            } else if (string2.equals("if")) {
                OpenTTY.ifCommand$(openTTY, string3);
            } else if (string2.equals("login")) {
                OpenTTY.login$(openTTY, string3);
            } else if (string2.equals("logout")) {
                if (openTTY.username.equals("")) {
                    OpenTTY.processCommand$(openTTY, "exit");
                } else {
                    openTTY.username = "";
                    OpenTTY.writeRMS$(openTTY, "OpenRMS", "");
                }
            } else if (string2.equals("locale")) {
                OpenTTY.echoCommand$(openTTY, OpenTTY.env$(openTTY, "$LOCALE"));
            } else if (string2.equals("lock")) {
                OpenTTY.lockCommand$(openTTY);
            } else if (string2.equals("open")) {
                OpenTTY.openCommand$(openTTY, string3);
            } else if (string2.equals("run")) {
                if (string3.equals("")) {
                    OpenTTY.runScript$(openTTY, openTTY.nanoContent);
                } else {
                    OpenTTY.runScript$(openTTY, OpenTTY.loadRMS$(openTTY, string3, 1));
                }
            } else if (string2.equals("set")) {
                OpenTTY.setCommand$(openTTY, string3);
            } else if (string2.equals("sh")) {
                openTTY.form.setTitle(OpenTTY.env$(openTTY, "OpenTTY $VERSION"));
                openTTY.output.setText(OpenTTY.env$(openTTY, "Welcome to OpenTTY $VERSION\nCopyright (C) 2024 - Mr. Lima\n"));
                openTTY.path = "/";
            } else if (!string2.equals("true") && !string2.equals("false")) {
                if (string2.equals("tty")) {
                    OpenTTY.echoCommand$(openTTY, OpenTTY.env$(openTTY, "$TTY"));
                } else if (string2.equals("ttysize")) {
                    OpenTTY.echoCommand$(openTTY, String.valueOf(openTTY.output.getText().length()).concat(" KB"));
                } else if (string2.equals("title")) {
                    if (string3.equals("")) {
                        openTTY.form.setTitle(OpenTTY.env$(openTTY, "OpenTTY $VERSION"));
                    } else {
                        openTTY.form.setTitle(string3);
                    }
                } else if (string2.equals("unalias")) {
                    OpenTTY.unaliasCommand$(openTTY, string3);
                } else if (string2.equals("uname")) {
                    OpenTTY.echoCommand$(openTTY, OpenTTY.env$(openTTY, "$TYPE $CONFIG $PROFILE"));
                } else if (string2.equals("unset")) {
                    OpenTTY.unsetCommand$(openTTY, string3);
                } else if (string2.equals("version")) {
                    OpenTTY.echoCommand$(openTTY, "OpenTTY ".concat(String.valueOf(openTTY.version)));
                } else if (string2.equals("whoami")) {
                    if (openTTY.username.equals("")) {
                        OpenTTY.echoCommand$(openTTY, "whoami: not logged");
                    } else {
                        OpenTTY.echoCommand$(openTTY, openTTY.username);
                    }
                } else if (string2.equals("warn")) {
                    OpenTTY.warnCommand$(openTTY, openTTY.form.getTitle(), string3);
                } else if (string2.equals("xorg")) {
                    if (string3.length() == 0 || string3.equals("help")) {
                        OpenTTY.viewer$(openTTY, "OpenTTY X.Org", OpenTTY.env$(openTTY, "OpenTTY X.Org - X Server $XVERSION\nRelease Date: 2024-07-25\nX Protocol Version 1, Revision 3\nBuild OS: $TYPE"));
                    } else if (string3.equals("stop")) {
                        openTTY.form = new Form("");
                        openTTY.display.setCurrent((Displayable)openTTY.form);
                    } else {
                        OpenTTY.echoCommand$(openTTY, "xorg: ".concat(String.valueOf(string3)).concat(": not found"));
                    }
                } else if (string2.equals("!")) {
                    OpenTTY.echoCommand$(openTTY, OpenTTY.env$(openTTY, "main/$RELEASE LTS\nIn memory of Silvio Santos"));
                } else if (string2.equals(".")) {
                    if (!string3.equals("")) {
                        if (string3.startsWith("/")) {
                            OpenTTY.runScript$(openTTY, OpenTTY.read$(openTTY, string3));
                        } else {
                            OpenTTY.runScript$(openTTY, OpenTTY.read$(openTTY, String.valueOf(openTTY.path).concat("/").concat(String.valueOf(string3))));
                        }
                    }
                } else if (string2.equals("silvio")) {
                    if (OpenTTY.env$(openTTY, "$LOCALE").equals("pt-BR")) {
                        OpenTTY.viewer$(openTTY, "Silvio Santos", OpenTTY.read$(openTTY, "/java/silvio-pt.txt"));
                    } else {
                        OpenTTY.viewer$(openTTY, "Silvio Santos", OpenTTY.read$(openTTY, "/java/silvio-en.txt"));
                    }
                } else {
                    OpenTTY.echoCommand$(openTTY, String.valueOf(string2).concat(": not found"));
                }
            }
        }
    }

    static String getCommand$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    static String getArgument$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1).trim();
    }

    static String extractTitle$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf("<title>");
        int n2 = string.indexOf("</title>");
        if (n != -1 && n2 != -1 && n2 > n) {
            return string.substring(n + 7, n2).trim();
        }
        return "HTML Viewer";
    }

    static String html2text$(OpenTTY openTTY, String string) throws  {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                bl = true;
                if (string.regionMatches(true, n, "<title>", 0, 7)) {
                    bl2 = true;
                } else if (string.regionMatches(true, n, "</title>", 0, 8)) {
                    bl2 = false;
                }
            } else if (c == '>') {
                bl = false;
            } else if (!bl && !bl2) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    static String parseJson$(OpenTTY openTTY, String string) throws  {
        Hashtable hashtable = OpenTTY.parseProperties$(openTTY, string);
        Enumeration enumeration = hashtable.keys();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            stringBuffer.append("\n  \"").append(string2).append("\": ");
            stringBuffer.append("\"").append(string3).append("\"");
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    static String loadRMS$(OpenTTY openTTY, String string, int n) throws  {
        RecordStore recordStore = null;
        String string2 = "";
        try {
            try {
                byte[] byArray;
                recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
                if (recordStore.getNumRecords() >= n && (byArray = recordStore.getRecord(n)) != null) {
                    string2 = new String(byArray);
                }
            }
            catch (RecordStoreException recordStoreException) {
                string2 = "";
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreException recordStoreException) {}
            }
        }
        return string2;
    }

    static String read$(OpenTTY openTTY, String string) throws  {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            InputStream inputStream = ((Object)((Object)openTTY)).getClass().getResourceAsStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            while ((n = inputStreamReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            inputStreamReader.close();
            return OpenTTY.env$(openTTY, stringBuffer.toString());
        }
        catch (IOException iOException) {
            return iOException.getMessage();
        }
    }

    static String replace$(OpenTTY openTTY, String string, String string2, String string3) throws  {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    static String env$(OpenTTY openTTY, String string) throws  {
        string = OpenTTY.replace$(openTTY, string, "$PATH", openTTY.path);
        string = OpenTTY.replace$(openTTY, string, "$USERNAME", openTTY.username);
        Enumeration enumeration = openTTY.attributes.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)openTTY.attributes.get(string2);
            string = OpenTTY.replace$(openTTY, string, "$".concat(String.valueOf(string2)), string3);
        }
        return string;
    }

    static String basename$(OpenTTY openTTY, String string) throws  {
        int n;
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = string.lastIndexOf(47)) == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    static String[] splitLines$(OpenTTY openTTY, String string) throws  {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                vector.addElement(string.substring(n, n2));
                n = n2 + 1;
            }
            ++n2;
        }
        if (n < string.length()) {
            vector.addElement(string.substring(n));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static Hashtable parseProperties$(OpenTTY openTTY, String string) throws  {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = OpenTTY.splitLines$(openTTY, string);
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            String string2 = stringArray[n];
            if (!string2.startsWith("#") && (n2 = string2.indexOf(61)) > 0 && n2 < string2.length() - 1) {
                String string3 = string2.substring(0, n2).trim();
                String string4 = string2.substring(n2 + 1).trim();
                hashtable.put(string3, string4);
            }
            ++n;
        }
        return hashtable;
    }

    static void aliasCommand$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            OpenTTY.echoCommand$(openTTY, "Usage: alias <name> <command>");
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        openTTY.aliases.put(string2, string3);
    }

    static void unaliasCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: unalias <alias>");
            return;
        }
        if (openTTY.aliases.containsKey(string)) {
            openTTY.aliases.remove(string);
        } else {
            OpenTTY.echoCommand$(openTTY, "unalias: ".concat(String.valueOf(string)).concat(": not found"));
        }
    }

    static void setCommand$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        if (n == -1) {
            OpenTTY.echoCommand$(openTTY, "Usage: set <key> <value>");
            return;
        }
        openTTY.attributes.put(string.substring(0, n).trim(), string.substring(n + 1).trim());
    }

    static void unsetCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: unset <key>");
            return;
        }
        if (openTTY.attributes.containsKey(string)) {
            openTTY.attributes.remove(string);
        } else {
            OpenTTY.echoCommand$(openTTY, "unalias: ".concat(String.valueOf(string)).concat(": not found"));
        }
    }

    static void echoCommand$(OpenTTY openTTY, String string) throws  {
        openTTY.output.setText(String.valueOf(openTTY.output.getText()).concat("\n").concat(String.valueOf(string)));
        openTTY.attributes.put("OUTPUT", string);
    }

    static void callCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            Form form = new Form(openTTY.form.getTitle());
            TextField textField = new TextField("Phone", "", 16, 2);
            Command command = new Command("Call", 4, 1);
            Command command2 = new Command("Cancel", 1, 2);
            form.append((Item)textField);
            form.addCommand(command);
            form.addCommand(command2);
            form.setCommandListener((CommandListener)new OpenTTY$1(openTTY, command2, textField, command));
            openTTY.display.setCurrent((Displayable)form);
            return;
        }
        try {
            openTTY.platformRequest("tel:".concat(String.valueOf(string)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void openCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            Form form = new Form(openTTY.form.getTitle());
            TextField textField = new TextField("API Url", "", 256, 0);
            Command command = new Command("Open", 4, 1);
            Command command2 = new Command("Cancel", 1, 2);
            form.append((Item)textField);
            form.addCommand(command);
            form.addCommand(command2);
            form.setCommandListener((CommandListener)new OpenTTY$2(openTTY, command2, textField, command));
            openTTY.display.setCurrent((Displayable)form);
            return;
        }
        try {
            openTTY.platformRequest(string);
        }
        catch (Exception exception) {
            OpenTTY.echoCommand$(openTTY, "open: ".concat(String.valueOf(string)).concat(": not found"));
        }
    }

    static void warnCommand$(OpenTTY openTTY, String string, String string2) throws  {
        if (string2 == null || string2.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: warn <message>");
            return;
        }
        Alert alert = new Alert(string, string2, null, AlertType.WARNING);
        alert.setTimeout(-2);
        openTTY.display.setCurrent(alert, (Displayable)openTTY.form);
    }

    static void lockCommand$(OpenTTY openTTY) throws  {
        if (openTTY.username == null || openTTY.username.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "lock: not logged");
            return;
        }
        Form form = new Form(String.valueOf(openTTY.form.getTitle()).concat(" - Locked"));
        TextField textField = new TextField("Username", "", 256, 0);
        StringItem stringItem = new StringItem("", "OpenTTY was blocked! Insert your\nusername to return to console.");
        Command command = new Command("Unlock", 4, 1);
        form.append((Item)stringItem);
        form.append((Item)textField);
        form.addCommand(command);
        form.setCommandListener((CommandListener)new OpenTTY$3(openTTY, command, form, textField));
        openTTY.display.setCurrent((Displayable)form);
    }

    static void htopCommand$(OpenTTY openTTY) throws  {
        Runtime runtime = Runtime.getRuntime();
        OpenTTY.viewer$(openTTY, openTTY.form.getTitle(), "Memory Status:\n\nUsed Memory: " + String.valueOf((runtime.totalMemory() - runtime.freeMemory()) / (long)1024) + " KB\nFree Memory: " + String.valueOf(runtime.freeMemory() / (long)1024) + " KB\nTotal Memory: " + String.valueOf(runtime.totalMemory() / (long)1024) + " KB");
    }

    static void showHistory$(OpenTTY openTTY) throws  {
        List list = new List("OpenTTY History", 3);
        Command command = new Command("Back", 2, 1);
        Command command2 = new Command("Run", 4, 2);
        Command command3 = new Command("Edit", 4, 2);
        int n = 0;
        while (n < openTTY.commandHistory.size()) {
            list.append((String)openTTY.commandHistory.elementAt(n), null);
            ++n;
        }
        list.addCommand(command);
        list.addCommand(command2);
        list.addCommand(command3);
        list.setCommandListener((CommandListener)new OpenTTY$4(openTTY, command, command3, command2, list));
        openTTY.display.setCurrent((Displayable)list);
    }

    static void nano$(OpenTTY openTTY) throws  {
        TextBox textBox = new TextBox("Nano", openTTY.nanoContent, 4096, 0);
        Command command = new Command("Back", 4, 1);
        Command command2 = new Command("Clear", 1, 2);
        Command command3 = new Command("View as HTML", 1, 3);
        textBox.addCommand(command);
        textBox.addCommand(command2);
        textBox.addCommand(command3);
        textBox.setCommandListener((CommandListener)new OpenTTY$5(openTTY, command, command3, textBox, command2));
        openTTY.display.setCurrent((Displayable)textBox);
    }

    static void viewer$(OpenTTY openTTY, String string, String string2) throws  {
        Form form = new Form(string);
        StringItem stringItem = new StringItem(null, string2);
        Command command = new Command("Back", 4, 1);
        form.addCommand(command);
        form.append((Item)stringItem);
        form.setCommandListener((CommandListener)new OpenTTY$6(openTTY, command));
        openTTY.display.setCurrent((Displayable)form);
    }

    static void runScript$(OpenTTY openTTY, String string) throws  {
        String[] stringArray = OpenTTY.splitLines$(openTTY, string);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = OpenTTY.env$(openTTY, stringArray[n].trim());
            if (!string2.startsWith("#")) {
                OpenTTY.processCommand$(openTTY, string2);
            }
            ++n;
        }
    }

    static void mount$(OpenTTY openTTY, String string) throws  {
        String[] stringArray = OpenTTY.splitLines$(openTTY, string);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = "";
            if (stringArray[n] != null) {
                string2 = stringArray[n].trim();
            }
            if (!string2.startsWith("#") && string2.length() != 0 && string2.startsWith("/")) {
                String string3 = "";
                int n2 = 0;
                int n3 = 1;
                while (n3 < string2.length()) {
                    if (string2.charAt(n3) == '/') {
                        String string4 = string2.substring(n2 + 1, n3);
                        string3 = String.valueOf(string3).concat(String.valueOf("/".concat(String.valueOf(string4))));
                        OpenTTY.addDirectory$(openTTY, string3);
                        n2 = n3;
                    }
                    ++n3;
                }
                String string5 = string2.substring(n2 + 1);
                string3 = String.valueOf(string3).concat(String.valueOf("/".concat(String.valueOf(string5))));
                OpenTTY.addDirectory$(openTTY, string3);
            }
            ++n;
        }
    }

    static void addDirectory$(OpenTTY openTTY, String string) throws  {
        if (!openTTY.paths.containsKey(string)) {
            openTTY.paths.put(string, new String[]{".."});
            String string2 = string.substring(0, string.lastIndexOf(47));
            if (string2.length() == 0) {
                string2 = "/";
            }
            String[] stringArray = (String[])openTTY.paths.get(string2);
            Vector<String> vector = new Vector<String>();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    vector.addElement(stringArray[n]);
                    ++n;
                }
            }
            vector.addElement(string.substring(string.lastIndexOf(47) + 1));
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            openTTY.paths.put(string2, objectArray);
        }
    }

    static void changeDisk$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: cd <dir>");
            return;
        }
        String[] stringArray = (String[])openTTY.paths.get(openTTY.path);
        if (stringArray != null) {
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                openTTY.path = string.equals("..") ? ((n = openTTY.path.lastIndexOf(47)) == 0 ? "/" : openTTY.path.substring(0, n)) : (openTTY.path.equals("/") ? "/".concat(String.valueOf(string)) : String.valueOf(openTTY.path).concat("/").concat(String.valueOf(string)));
            } else {
                if (string.equals("/") || string.equals(".") || string.equals("..")) {
                    openTTY.path = "/";
                    return;
                }
                OpenTTY.echoCommand$(openTTY, "cd: ".concat(String.valueOf(string)).concat(": not found"));
            }
        } else {
            OpenTTY.echoCommand$(openTTY, "cd: ".concat(String.valueOf(string)).concat(": not found"));
        }
    }

    static void ifCommand$(OpenTTY openTTY, String string) throws  {
        int n = string.indexOf(32);
        int n2 = string.indexOf(32, n + 1);
        if (n == -1) {
            OpenTTY.echoCommand$(openTTY, "Usage: if <x> <y> [command] ");
            return;
        }
        if (n2 == -1) {
            OpenTTY.processCommand$(openTTY, "warn java.io.IOException: missing operators");
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1, n2).trim();
        String string4 = string.substring(n2 + 1).trim();
        if (string2.equals(string3)) {
            OpenTTY.processCommand$(openTTY, string4);
        }
        if (string2.equals("not") && string3.equals("")) {
            OpenTTY.processCommand$(openTTY, string4);
        }
        if (string2.equals("is") && !string3.equals("")) {
            OpenTTY.processCommand$(openTTY, string4);
        }
    }

    static void writeRMS$(OpenTTY openTTY, String string, String string2) throws  {
        block11: {
            RecordStore recordStore = null;
            try {
                try {
                    recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
                    byte[] byArray = string2.getBytes();
                    if (recordStore.getNumRecords() > 0) {
                        recordStore.setRecord(1, byArray, 0, byArray.length);
                        break block11;
                    }
                    recordStore.addRecord(byArray, 0, byArray.length);
                }
                catch (RecordStoreException recordStoreException) {}
            }
            finally {
                if (recordStore != null) {
                    try {
                        recordStore.closeRecordStore();
                    }
                    catch (RecordStoreException recordStoreException) {}
                }
            }
        }
    }

    static void install$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            Form form = new Form(openTTY.form.getTitle());
            TextField textField = new TextField("Filename", "", 16, 0);
            Command command = new Command("Save", 4, 1);
            Command command2 = new Command("Cancel", 1, 2);
            form.append((Item)textField);
            form.addCommand(command);
            form.addCommand(command2);
            form.setCommandListener((CommandListener)new OpenTTY$7(openTTY, command2, textField, command));
            openTTY.display.setCurrent((Displayable)form);
        } else {
            OpenTTY.writeRMS$(openTTY, string, openTTY.nanoContent);
        }
    }

    static void loadCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            Form form = new Form(openTTY.form.getTitle());
            TextField textField = new TextField("Filename", "", 16, 0);
            Command command = new Command("Load", 4, 1);
            Command command2 = new Command("Cancel", 1, 2);
            form.append((Item)textField);
            form.addCommand(command);
            form.addCommand(command2);
            form.setCommandListener((CommandListener)new OpenTTY$8(openTTY, command2, textField, command));
            openTTY.display.setCurrent((Displayable)form);
        } else {
            openTTY.nanoContent = OpenTTY.loadRMS$(openTTY, string, 1);
        }
    }

    static void login$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0 || !openTTY.username.equals("")) {
            OpenTTY.processCommand$(openTTY, "sh");
            return;
        }
        openTTY.username = string;
        OpenTTY.writeRMS$(openTTY, "OpenRMS", string);
    }

    static void netstat$(OpenTTY openTTY) throws  {
        new Thread(new OpenTTY$9(openTTY)).start();
    }

    static void fwCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            string = "json";
        }
        String string2 = "http://ipinfo.io/".concat(String.valueOf(string));
        new Thread(new OpenTTY$10(openTTY, string2)).start();
    }

    static void curlCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: curl <url>");
            return;
        }
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            string = "http://".concat(String.valueOf(string));
        }
        new Thread(new OpenTTY$11(openTTY, string)).start();
    }

    static void wgetCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: wget <url>");
            return;
        }
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            string = "http://".concat(String.valueOf(string));
        }
        new Thread(new OpenTTY$12(openTTY, string)).start();
    }

    static void pingCommand$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: ping <url>");
            return;
        }
        if (!string.startsWith("http://") && !string.startsWith("https://")) {
            string = "http://".concat(String.valueOf(string));
        }
        new Thread(new OpenTTY$13(openTTY, string)).start();
    }

    static void connect$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: nc <ip:port>");
            return;
        }
        try {
            SocketConnection socketConnection = (SocketConnection)Connector.open((String)"socket://".concat(String.valueOf(string)));
            InputStream inputStream = socketConnection.openInputStream();
            OutputStream outputStream = socketConnection.openOutputStream();
            Form form = new Form(openTTY.form.getTitle());
            TextField textField = new TextField("Remote", "", 256, 0);
            Command command = new Command("Send", 4, 1);
            Command command2 = new Command("Back", 1, 2);
            Command command3 = new Command("Clear", 1, 3);
            StringItem stringItem = new StringItem("", "");
            form.append((Item)stringItem);
            form.append((Item)textField);
            form.addCommand(command2);
            form.addCommand(command3);
            form.addCommand(command);
            form.setCommandListener((CommandListener)new OpenTTY$14(openTTY, stringItem, inputStream, command, command2, textField, command3, outputStream));
            openTTY.display.setCurrent((Displayable)form);
        }
        catch (IOException iOException) {
            OpenTTY.processCommand$(openTTY, "warn ".concat(String.valueOf(iOException.getMessage())));
        }
    }

    static void runServer$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0 || string.equals("$PORT")) {
            OpenTTY.processCommand$(openTTY, "set PORT 4095");
            OpenTTY.runServer$(openTTY, "4095");
            return;
        }
        new Thread(new OpenTTY$15(openTTY, string)).start();
    }

    static void portScanner$(OpenTTY openTTY, String string) throws  {
        if (string == null || string.length() == 0) {
            OpenTTY.echoCommand$(openTTY, "Usage: prscan <ip>");
            return;
        }
        List list = new List(String.valueOf(string).concat(" Ports"), 3);
        Command command = new Command("Connect", 4, 1);
        Command command2 = new Command("Back", 2, 2);
        list.addCommand(command);
        list.addCommand(command2);
        list.setCommandListener((CommandListener)new OpenTTY$16(openTTY, list, command2, string, command));
        new Thread(new OpenTTY$17(openTTY, list, string)).start();
    }
}

